/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.web;

import org.apache.struts.action.ActionForm;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.ksb.messaging.threadpool.KSBThreadPool;


/**
 * Struts ActionForm for the {@link ThreadPoolAction}.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class ThreadPoolForm extends ActionForm {

    private static final long serialVersionUID = 6670668383823543732L;

    private String methodToCall;
    private KSBThreadPool threadPool;
    private Integer corePoolSize; //editable
    private Integer maximumPoolSize; //editable

    private boolean allServers;
    private Long timeIncrement;
    private Long maxRetryAttempts;

    public String getMethodToCall() {
        return this.methodToCall;
    }
    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }
    public Integer getCorePoolSize() {
        return this.corePoolSize;
    }
    public void setCorePoolSize(Integer corePoolSize) {
        this.corePoolSize = corePoolSize;
    }
    public Integer getMaximumPoolSize() {
        return this.maximumPoolSize;
    }
    public void setMaximumPoolSize(Integer maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }
    public KSBThreadPool getThreadPool() {
        return this.threadPool;
    }
    public void setThreadPool(KSBThreadPool threadPool) {
        this.threadPool = threadPool;
    }
    public boolean isAllServers() {
        return this.allServers;
    }
    public void setAllServers(boolean allServers) {
        this.allServers = allServers;
    }
    public String getApplicationId() {
    	return CoreConfigHelper.getApplicationId();
    }
    public Long getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }
    public void setMaxRetryAttempts(Long maxRetryAttempts) {
        this.maxRetryAttempts = maxRetryAttempts;
    }
    public Long getTimeIncrement() {
        return this.timeIncrement;
    }
    public void setTimeIncrement(Long timeIncrement) {
        this.timeIncrement = timeIncrement;
    }

}
