/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.kuali.rice.core.api.CoreConstants;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.ksb.api.KsbApiConstants;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.ServiceBusAdminService;


/**
 * Struts action for interacting with the queue of messages.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ServiceBusAction extends KSBAction {

    private static final QName SERVICE_BUS_ADMIN_SERVICE_QUEUE = new QName(
            KsbApiConstants.Namespaces.KSB_NAMESPACE_2_0, "serviceBusAdminService");
    private static final Logger LOG = LogManager.getLogger(ServiceBusAction.class);

    @Override
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request,
                               HttpServletResponse response) throws IOException, ServletException {
		return mapping.findForward("basic");
	}

	public ActionForward refreshServiceBus(ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws IOException, ServletException {

        String applicationId = ConfigContext.getCurrentContextConfig().getProperty(
                CoreConstants.Config.APPLICATION_ID);

        List<Endpoint> endpoints = KsbApiServiceLocator.getServiceBus().getEndpoints(SERVICE_BUS_ADMIN_SERVICE_QUEUE, applicationId);
        if (endpoints.isEmpty()) {
            KsbApiServiceLocator.getServiceBus().synchronize();
        } else {
            for (Endpoint endpoint : endpoints) {
                ServiceBusAdminService serviceBusAdminService = (ServiceBusAdminService) endpoint.getService();
                LOG.info("Calling " + endpoint.getServiceConfiguration().getEndpointUrl() + " on " +
                    endpoint.getServiceConfiguration().getInstanceId());

                serviceBusAdminService.clearServiceBusCache();
            }
        }
		return mapping.findForward("basic");
	}

	@Override
    public ActionMessages establishRequiredState(HttpServletRequest request, ActionForm actionForm) throws Exception {
		ServiceBusForm form = (ServiceBusForm)actionForm;
		form.setMyIpAddress(RiceUtilities.getIpNumber());
		form.setMyApplicationId(CoreConfigHelper.getApplicationId());
		form.setDevMode(ConfigContext.getCurrentContextConfig().getDevMode());
		ServiceBus serviceBus = KsbApiServiceLocator.getServiceBus();
		form.setMyInstanceId(serviceBus.getInstanceId());
		form.setPublishedServices(getPublishedServices(serviceBus));
		form.setGlobalServices(getGlobalServices(serviceBus));

		return null;
	}

	private List<ServiceConfiguration> getPublishedServices(ServiceBus serviceBus) {
		Map<QName, Endpoint> localEndpoints = serviceBus.getLocalEndpoints();
		List<ServiceConfiguration> publishedServices = new ArrayList<ServiceConfiguration>();
		for (Endpoint endpoint : localEndpoints.values()) {
			publishedServices.add(endpoint.getServiceConfiguration());
		}
		return publishedServices;
	}

	private List<ServiceConfiguration> getGlobalServices(ServiceBus serviceBus) {
		List<ServiceConfiguration> allServices = new ArrayList<ServiceConfiguration>();
		for(Endpoint endpoint : serviceBus.getAllEndpoints()) {
			allServices.add(endpoint.getServiceConfiguration());
		}
		return allServices;
	}

}
