/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.web;

import org.apache.struts.action.ActionForm;
import org.quartz.JobDetail;
import org.quartz.Trigger;


/**
 * Struts form for quartz queue processing 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class QuartzQueueForm extends ActionForm {

    private static final long serialVersionUID = 4589673941470488079L;
    
    private String jobName;
    private String jobGroup;
    private JobDetail jobDetail;
    private Trigger trigger;
    
    public QuartzQueueForm() {}
    
    public QuartzQueueForm(JobDetail jobDetail, Trigger trigger) {
	this.jobDetail = jobDetail;
	this.trigger = trigger;
    }
    
    public JobDetail getJobDetail() {
        return this.jobDetail;
    }
    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }
    public Trigger getTrigger() {
        return this.trigger;
    }
    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }
    public String getJobGroup() {
        return this.jobGroup;
    }
    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }
    public String getJobName() {
        return this.jobName;
    }
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }   
}
