/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.api.services;

import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.location.api.campus.CampusService;
import org.kuali.rice.location.api.country.CountryService;
import org.kuali.rice.location.api.county.CountyService;
import org.kuali.rice.location.api.postalcode.PostalCodeService;
import org.kuali.rice.location.api.state.StateService;

/**
 * <p>LocationApiServiceLocator class.</p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class LocationApiServiceLocator {

    public static final String COUNTRY_SERVICE = "countryService";

    public static final String CAMPUS_SERVICE = "campusService";

    public static final String STATE_SERVICE = "stateService";

    public static final String COUNTY_SERVICE = "countyService";

    public static final String POSTAL_CODE_SERVICE = "postalCodeService";

    static <T> T getService(String serviceName) {
        return GlobalResourceLoader.<T>getService(serviceName);
    }

    public static CountryService getCountryService() {
        return getService(COUNTRY_SERVICE);
    }

    public static CampusService getCampusService() {
        return getService(CAMPUS_SERVICE);
    }

    public static StateService getStateService() {
        return getService(STATE_SERVICE);
    }

    public static CountyService getCountyService() {
        return (CountyService) getService(COUNTY_SERVICE);
    }

    public static PostalCodeService getPostalCodeService() {
        return (PostalCodeService) getService(POSTAL_CODE_SERVICE);
    }
    
}
