/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.api.campus;

import org.kuali.rice.core.api.mo.common.Coded;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;


/**
 * <p>CampusContract interface.</p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface CampusContract extends Versioned, GloballyUnique, Inactivatable, Coded {

	/**
	 * This is the name for the Campus.
	 *
	 * <p>
	 * It is a name a campus.
	 * </p>
	 *
	 * @return name for Campus.
	 */
	String getName();

	/**
	 * This is the short name for the Campus.
	 *
	 * <p>
	 * It is a shorter name for a campus.
	 * </p>
	 *
	 * @return short name for Campus.
	 */
	String getShortName();

	/**
	 * This is the campus type for the Campus.
	 *
	 * <p>
	 * It is a object that defines the type of a campus.
	 * </p>
	 *
	 * @return short name for Campus.
	 */
	CampusTypeContract getCampusType();
}
