/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.framework.country;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;

public abstract class AbstractCountryValuesFinderBase
extends KeyValuesBase {
    public List<KeyValue> getKeyValues() {
        Country defaultCountry = this.getDefaultCountry();
        ArrayList<Country> countries = new ArrayList<Country>(this.retrieveCountriesForValuesFinder());
        ArrayList<KeyValue> values = new ArrayList<KeyValue>(countries.size() + 1);
        values.add((KeyValue)new ConcreteKeyValue("", ""));
        if (defaultCountry != null) {
            values.add((KeyValue)new ConcreteKeyValue(defaultCountry.getCode(), this.getName(defaultCountry)));
        }
        countries.sort((country1, country2) -> {
            String sortValue1 = StringUtils.trim((String)StringUtils.removeStart((String)this.getName((Country)country1), (String)"*"));
            String sortValue2 = StringUtils.trim((String)StringUtils.removeStart((String)this.getName((Country)country2), (String)"*"));
            return sortValue1.compareToIgnoreCase(sortValue2);
        });
        for (Country country : countries) {
            if (!country.isActive()) continue;
            values.add((KeyValue)new ConcreteKeyValue(country.getCode(), this.getName(country)));
        }
        return values;
    }

    private String getName(Country country) {
        return StringUtils.isNotBlank((String)country.getNameV3()) ? country.getNameV3() : country.getName();
    }

    protected abstract List<Country> retrieveCountriesForValuesFinder();

    protected Country getDefaultCountry() {
        return LocationApiServiceLocator.getCountryService().getDefaultCountry();
    }
}

