/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.impl.campus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.CriteriaLookupService;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.location.api.campus.Campus;
import org.kuali.rice.location.api.campus.CampusContract;
import org.kuali.rice.location.api.campus.CampusQueryResults;
import org.kuali.rice.location.api.campus.CampusService;
import org.kuali.rice.location.api.campus.CampusType;
import org.kuali.rice.location.api.campus.CampusTypeContract;
import org.kuali.rice.location.api.campus.CampusTypeQueryResults;
import org.kuali.rice.location.impl.campus.CampusBo;
import org.kuali.rice.location.impl.campus.CampusTypeBo;

public class CampusServiceImpl
implements CampusService {
    private BusinessObjectService boService;
    private CriteriaLookupService criteriaLookupService;

    public Campus getCampus(String code) {
        if (StringUtils.isBlank((String)code)) {
            throw new RiceIllegalArgumentException("code is blank");
        }
        CampusBo campusBo = (CampusBo)this.boService.findByPrimaryKey(CampusBo.class, Collections.singletonMap("code", code));
        return CampusBo.to(campusBo);
    }

    public List<Campus> findAllCampuses() {
        List campusBos = (List)this.boService.findMatching(CampusBo.class, Collections.singletonMap("active", "true"));
        return this.convertListOfCampusBosToImmutables(campusBos);
    }

    public CampusType getCampusType(String code) {
        if (StringUtils.isBlank((String)code)) {
            throw new RiceIllegalArgumentException("code is blank");
        }
        CampusTypeBo campusTypeBo = (CampusTypeBo)this.boService.findByPrimaryKey(CampusTypeBo.class, Collections.singletonMap("code", code));
        return CampusTypeBo.to(campusTypeBo);
    }

    public List<CampusType> findAllCampusTypes() {
        List campusTypeBos = (List)this.boService.findMatching(CampusTypeBo.class, Collections.singletonMap("active", "true"));
        return this.convertListOfCampusTypesBosToImmutables(campusTypeBos);
    }

    public CampusQueryResults findCampuses(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        GenericQueryResults results = this.criteriaLookupService.lookup(CampusBo.class, queryByCriteria);
        CampusQueryResults.Builder builder = CampusQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Campus.Builder> ims = new ArrayList<Campus.Builder>();
        for (CampusBo bo : results.getResults()) {
            ims.add(Campus.Builder.create((CampusContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public CampusTypeQueryResults findCampusTypes(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "query");
        GenericQueryResults results = this.criteriaLookupService.lookup(CampusTypeBo.class, queryByCriteria);
        CampusTypeQueryResults.Builder builder = CampusTypeQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<CampusType.Builder> ims = new ArrayList<CampusType.Builder>();
        for (CampusTypeBo bo : results.getResults()) {
            ims.add(CampusType.Builder.create((CampusTypeContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public void setBusinessObjectService(BusinessObjectService boService) {
        this.boService = boService;
    }

    private List<Campus> convertListOfCampusBosToImmutables(List<CampusBo> campusBos) {
        ArrayList<Campus> campuses = new ArrayList<Campus>();
        for (CampusBo bo : campusBos) {
            Campus campus = CampusBo.to(bo);
            campuses.add(campus);
        }
        return Collections.unmodifiableList(campuses);
    }

    private List<CampusType> convertListOfCampusTypesBosToImmutables(List<CampusTypeBo> campusTypeBos) {
        ArrayList<CampusType> campusTypes = new ArrayList<CampusType>();
        for (CampusTypeBo bo : campusTypeBos) {
            CampusType campusType = CampusTypeBo.to(bo);
            campusTypes.add(campusType);
        }
        return Collections.unmodifiableList(campusTypes);
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }

    public void setCriteriaLookupService(CriteriaLookupService criteriaLookupService) {
        this.criteriaLookupService = criteriaLookupService;
    }
}

