/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.krms.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.krms.api.KrmsApiServiceLocator;
import org.kuali.rice.krms.api.repository.function.FunctionDefinition;
import org.kuali.rice.krms.api.repository.operator.CustomOperator;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.framework.engine.Function;
import org.kuali.rice.krms.framework.type.FunctionTypeService;
import org.kuali.rice.krms.impl.repository.FunctionBoService;

public class ContainsOperator
implements CustomOperator,
FunctionTypeService {
    public FunctionDefinition getOperatorFunctionDefinition() {
        FunctionBoService functionBoService = (FunctionBoService)GlobalResourceLoader.getService((String)"functionRepositoryService");
        KrmsTypeRepositoryService typeRepository = KrmsApiServiceLocator.getKrmsTypeRepositoryService();
        KrmsTypeDefinition containsOperatorType = typeRepository.getTypeByName("KR-SAP", "contains operator");
        if (containsOperatorType == null) {
            throw new IllegalStateException("There must be a persisted KRMS type with namespace 'KR-SAP', name 'contains operator', and serviceName 'sampleAppContainsOperatorService'");
        }
        FunctionDefinition containsFunction = functionBoService.getFunctionByNameAndNamespace("contains", "KR-SAP");
        if (containsFunction == null) {
            FunctionDefinition.Builder functionBuilder = FunctionDefinition.Builder.create((String)"KR-SAP", (String)"contains", (String)"java.lang.Boolean", (String)containsOperatorType.getId());
            containsFunction = functionBoService.createFunction(functionBuilder.build());
        }
        return containsFunction;
    }

    public List<RemotableAttributeError> validateOperandClasses(String lhsClassName, String rhsClassName) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        if (String.class.getName().equals(lhsClassName)) {
            if (!String.class.getName().equals(rhsClassName)) {
                RemotableAttributeError.Builder errorBuilder = RemotableAttributeError.Builder.create((String)"operator", (String[])new String[]{"right hand operand is not a String"});
                errors.add(errorBuilder.build());
            }
        } else {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(lhsClassName);
                if (!Collection.class.isAssignableFrom(clazz)) {
                    RemotableAttributeError.Builder errorBuilder = RemotableAttributeError.Builder.create((String)"operator", (String[])new String[]{"left hand operand is not a Collection"});
                    errors.add(errorBuilder.build());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return errors;
    }

    public Function loadFunction(FunctionDefinition functionDefinition) {
        if (!"contains".equals(functionDefinition.getName()) || "KR-SAP".equals(functionDefinition.getNamespace())) {
            throw new IllegalArgumentException("oops, you have the wrong type service, I can't load this function");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

