<%--
  #%L
  %%
  Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>
<c:set var="ruleAttributes" value="${DataDictionary.RuleBaseValues.attributes}" />

<kul:tabTop tabTitle="Choose Parent Rule" defaultOpen="true">

    <div class="tab-container" align=center >
        <h3>Select Parent Rule</h3>
	    <table cellpadding="0" cellspacing="0" class="datatable" summary="Parent Rule Section">
			<tr>
				<th align=right valign=middle class="bord-l-b"><label for="parentRuleId">Select parent rule:</label></th>
				<td align=left valign=middle class="datacell">
				    <kul:htmlControlAttribute attributeEntry="${ruleAttributes.id}" property="parentRuleId" readOnly="true" readOnlyAlternateDisplay="${fn:escapeXml(KualiForm.ruleDescription)}"/>
				    <kul:lookup boClassName="org.kuali.rice.kew.rule.RuleBaseValues" fieldConversions="id:parentRuleId"/>
				</td>
			</tr>
	    </table>
    </div>

	<c:if test="${KualiForm.parentRule != null}">

    <div class="tab-container" align=center >
        <h3>Select Parent Responsibility to Delegate From</h3>
	    <table cellpadding="0" cellspacing="0" class="datatable" summary="Parent Responsibility Section">
			<tr>
				<th align=middle valign=middle class="bord-l-b" width="10%">Select</th>
				<th align=middle valign=middle class="bord-l-b">Reviewer</th>
				<th align=middle valign=middle class="bord-l-b">Type</th>
				<th align=middle valign=middle class="bord-l-b">Action Request Code</th>
			</tr>
			<c:forEach items="${KualiForm.parentRule.ruleResponsibilities}" varStatus="status" var="responsibility">
			  <tr>
			    <td align=middle valign=middle class="datacell">
			      <html:radio property="parentResponsibilityId" title="Responsibility ${status.index}" value="${responsibility.responsibilityId}" styleId="parentResponsibilityId"/>
			    </td>
			    <td align=left valign=middle class="datacell">
			      ${KualiForm.reviewers[status.index]}
			    </td>
			    <td align=left valign=middle class="datacell">
			      ${KualiForm.responsibilityTypes[status.index]}
			    </td>
			    <td align=left valign=middle class="datacell">
			      ${KualiForm.actionRequestCodes[status.index]}
			    </td>
			</tr>
			</c:forEach>
	    </table>
    </div>

    </c:if>


</kul:tabTop>
