<%--
  #%L
  %%
  Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp" %>
<%@ attribute name="attributeDefinitions" required="true" type="java.util.List"
              description="The list of KIM Attribute Fields." %>
<%@ attribute name="pathPrefix" required="true"
              description="The prefix of values that are returned.  For instance, if the pathPrefix is document and the lookup is on organizationCode, the lookup will populate document.organizationCode in the form." %>
<%@ attribute name="attr" required="true" type="org.kuali.rice.core.api.uif.RemotableQuickFinder"
              description="The data dictionary definition of the attribute this lookup will help populate." %>
<%--  handling multiple lookup --%>
<c:set var="fieldConversion" value=""/>
<c:set var="params" value=""/>

<c:forEach var="attrDefn" items="${attributeDefinitions}" varStatus="defidx">
  <c:set var="searchStr" value="${attrDefn.attributeField.name}"/>
  <c:forEach items="${attr.fieldConversions}" var="lookupReturn" varStatus="lookupIdx">
    <c:if test="${lookupReturn.key == searchStr}">
      <c:set var="fieldConversion"
             value="${fieldConversion},${searchStr}:${pathPrefix}.qualifiers[${defidx.index}].attrVal"/>
    </c:if>
    <c:if test="${lookupReturn.key != searchStr and lookupReturn.value == searchStr}">
      <c:set var="fieldConversion"
             value="${fieldConversion},${lookupReturn.key}:${pathPrefix}.qualifiers[${defidx.index}].attrVal"/>
    </c:if>
  </c:forEach>

  <c:forEach items="${attr.lookupParameters}" var="lookupInput" varStatus="lookupIdx">
    <c:if test="${lookupInput.key == searchStr}">
      <%-- TODO : replace searstr with fielname for testing --%>

      <c:set var="params" value="${params},${pathPrefix}.qualifiers[${defidx.index}].attrVal:${lookupInput.value}"/>

    </c:if>
  </c:forEach>
</c:forEach>

<c:set var="fieldConversion" value="${fn:substringAfter(fieldConversion, ',')}"/>
<c:set var="params" value="${fn:substringAfter(params, ',')}"/>
  <kul:lookup boClassName="${attr.dataObjectClass}"
              fieldConversions="${fieldConversion}"
              lookupParameters="${params}"
              baseLookupUrl="${attr.baseLookupUrl}"/>
