<%--
  #%L
  %%
  Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<%@ attribute name="field" required="true" type="org.kuali.rice.kns.web.ui.Field" description="The field to render radio button options for." %>
<%@ attribute name="onblur" required="false" description="Javascript code which will be executed with the input field's onblur event is triggered." %>
<%@ attribute name="onchange" required="false" description="Javascript code which will be executed with the input field's onchange event is triggered." %>
<%@ attribute name="tabIndex" required="false" description="Tab index to use for next field" %>

${kfunc:registerEditableProperty(KualiForm, field.propertyName)}
<c:forEach items="${field.fieldValidValues}" var="radio">
  <c:if test="${!empty radio.value}">
    <input type="radio"
        ${field.propertyValue eq radio.key ? 'checked="checked"' : ''}
        name='${field.propertyName}'
        id='${field.propertyName}${radio.value}'
        value='<c:out value="${radio.key}" />'
		title='${field.fieldLabel} - ${radio.value}'
        onblur="${onblur}" onchange="${onchange}" tabIndex="${tabIndex}" aria-label='<c:out value="${radio.value}"/>'/>
    <label for='${field.propertyName}${radio.value}'><c:out value="${radio.value}"/></label>
  </c:if>
  
  <c:set var="tabIndex" value="${KualiForm.currentTabIndex}"/>
  <c:set var="dummyIncrementVar" value="${kfunc:incrementTabIndex(KualiForm, tabIndex)}" />
</c:forEach>
