<#--
 #%L
 %%
 Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#--
Control for outputting options or selected options (KeyValues) as readOnly.  Also supports navigation options.

-->
<#macro uif_optionList control field>

    <#local attributes='class="${control.styleClassesAsString!}" ${control.simpleDataAttributes!} '/>

    <#if control.tabIndex < 0>
        <#local attributes='${attributes} tabindex="${control.tabIndex!}"' />
    </#if>

    <#if control.disabled>
        <#local attributes='${attributes} disabled="disabled"'/>
    </#if>

    <#if control.style?has_content>
        <#local attributes='${attributes} style="${control.style}"'/>
    </#if>

    <#local isSelected=false>

    <#if field.propertyName?has_content>
        <#local path="KualiForm.${field.bindingInfo.bindingPath}"/>
        <@spring.bind path/>
    </#if>

    <#if control.options?has_content>
    <ul id="${control.id}" ${attributes}>
        <#list control.options as option>
        <#--check for key match if backed by property name-->
            <#if field.propertyName?has_content && spring.status.actualValue?has_content
            && spring.status.actualValue?is_sequence>
                <#local isSelected=spring.contains(spring.status.actualValue?default([""]), option.key)>
            <#elseif field.propertyName?has_content && spring.status.actualValue?has_content>
                <#local isSelected=spring.status.actualValue?string == option.key>
            </#if>

        <#--selected class-->
            <#if isSelected>
                <#local selectedItemCssClass=" ${control.selectedItemCssClass}"/>
            <#else>
                <#local selectedItemCssClass=""/>
            </#if>

        <#--Build items-->
            <#if isSelected ||(!isSelected && !control.showOnlySelected)>
                <li class="${control.itemCssClass}${selectedItemCssClass}">
                    <#if option.location?has_content && option.location.href?has_content>
                        <a data-key="${option.key?html}"
                           href="${option.location.href}">${option.value?html}</a>
                    <#else>
                        <span data-key="${option.key?html}">${option.value?html}</span>
                    </#if>
                </li>
            </#if>
        </#list>
    </ul>
    </#if>

</#macro>
