<%--
  #%L
  %%
  Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp" %>

<html-el:form action="/WorkflowDocHandler.do" >
  <html-el:hidden property="lookupableImplServiceName" value="${ActionForm.lookupableImplServiceName}" />
  <kul:csrf />
  <table align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="bord-r-t">
    <c:if test="${(! ActionForm.superUserSearch) && (ActionForm.command != 'displayActionListInlineView') && (ActionForm.workflowDocument.approvalRequested || ActionForm.workflowDocument.completionRequested ||
                 ActionForm.showBlanketApproveButton || ActionForm.workflowDocument.FYIRequested || ActionForm.workflowDocument.acknowledgeRequested)}">
      <tr>
        <td height=30>
          <table width="100%" border=0 cellpadding=0 cellspacing=0">
            <tr>
              <td width="25%" align=right valign=top class="thnormal"><label for="annotation">Annotation:</label>
              </td>
              <td width="75%" class="datacell">
                <html-el:textarea property="annotation" styleId="annotation" cols="50" rows="6" title="Annotation" value="${ActionForm.annotation}" />
              </td>
            </tr>
          </table>
        </td>
      </tr>

      <tr>
	    <td class="thnormal" align="center">
	      <html-el:hidden property="docId" value="${ActionForm.workflowDocument.documentId}" />
          <html-el:hidden property="inputPage" value="${inputLocation}"></html-el:hidden>

		      <c:if test="${ActionForm.workflowDocument.approvalRequested || ActionForm.workflowDocument.completionRequested}">
		      	<c:if test="${ActionForm.workflowDocument.blanketApproveCapable}">
	              <html-el:image src="${resourcePath}images/buttonsmall_blanketapp.gif" align="absmiddle" property="methodToCall.blanketApprove" />
		      	</c:if>
		  	    <c:if test="${ActionForm.workflowDocument.completionRequested}">
	              <html-el:image src="${resourcePath}images/buttonsmall_complete.gif" align="absmiddle" property="methodToCall.complete" />
		 	    </c:if>
		        <c:if test="${ActionForm.workflowDocument.approvalRequested}">
	              <html-el:image src="${resourcePath}images/buttonsmall_approve.gif" align="absmiddle" property="methodToCall.approve" />
		        </c:if>
	              <html-el:image src="${resourcePath}images/buttonsmall_disapprove.gif" align="absmiddle" property="methodToCall.disapprove" />
		  	      <html-el:image src="${resourcePath}images/buttonsmall_cancel.gif" align="absmiddle" property="methodToCall.cancel" />
		  	  </c:if>
		      <c:if test="${ActionForm.workflowDocument.FYIRequested}">
	            <html-el:image src="${resourcePath}images/buttonsmall_fyi.gif" align="absmiddle" property="methodToCall.fyi" />
		      </c:if>
		      <c:if test="${ActionForm.workflowDocument.acknowledgeRequested}">
	            <html-el:image src="${resourcePath}images/buttonsmall_acknowledge.gif" align="absmiddle" property="methodToCall.acknowledge" />
		      </c:if>
	    </td>
      </tr>
    </c:if>

  </table>
</html-el:form>
