<#--
 #%L
 %%
 Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#--
   Group of HTML Checkbox Inputs

 -->

<#macro uif_checkboxes control field>

    <#local attributes='class="${control.styleClassesAsString!}" ${control.simpleDataAttributes!} '/>

    <#if control.tabIndex < 0>
        <#local attributes='${attributes} tabindex="${control.tabIndex!}"' />
    </#if>

    <#if control.disabled>
        <#local attributes='${attributes} disabled="disabled"'/>
    </#if>

    <#if control.style?has_content>
        <#local attributes='${attributes} style="${control.style}"'/>
    </#if>

    <fieldset id="${field.id}_fieldset" aria-labelledby="${field.id}_label" class="${control.fieldsetClassesAsString}"
              data-type="CheckboxSet">
        <legend style="display: none">${field.label!}</legend>
        <@spring.formCheckboxes id="${control.id}" path="KualiForm.${field.bindingInfo.bindingPath}"
                 options=control.richOptions separator="${control.delimiter!}" attributes="${attributes}"/>
    </fieldset>

    <@krad.disable control=field.control type="checkboxGroup"/>

</#macro>
