<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp" %>
<%@ tag body-content="empty" %>
<%@ attribute name="roleIdx" required="true"
              description="In the list of roles a Person is a member of in the IdentityManagementPersonDocument, the index of the role to display qualifiers for." %>
<%@ attribute name="role" required="true" type="org.kuali.rice.kim.bo.ui.PersonDocumentRole"
              description="Information about the displayed/maintained Person's relationship to the role displayed by this tag." %>
<c:set var="docRolePrncplAttributes" value="${DataDictionary.KimDocumentRoleMember.attributes}"/>
<c:set var="docRoleRspActionAttributes" value="${DataDictionary.KimDocumentRoleResponsibilityAction.attributes}"/>

<kul:subtab lookedUpCollectionName="roleQualifier" width="${tableWidth}" subTabTitle="Role Qualifier"
            useCurrentTabIndexAsKey="true">
  <table cellpadding="0" cellspacing="0" summary="">
    <tr>
      <th width="5%" rowspan="20" style="border-style:none">&nbsp;</th>
      <th>&nbsp;</th>
      <c:forEach var="attrDefn" items="${role.definitions}" varStatus="status">
        <c:set var="attr" value="${attrDefn.attributeField}"/>
        <%-- AttrDefn: ${attr}<br /> --%>
        <c:set var="fieldName" value="${attr.name}"/>
        <c:set var="attrEntry" value="${role.attributeEntry[fieldName]}"/>
        <kul:htmlAttributeHeaderCell attributeEntry="${attrEntry}" useShortLabel="false"/>
      </c:forEach>
      <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center"
                attributeEntry="${docRolePrncplAttributes.activeFromDate}" noColon="true"/>
      <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center"
                attributeEntry="${docRolePrncplAttributes.activeToDate}" noColon="true"/>
      <c:if test="${not inquiry}">
        <kul:htmlAttributeHeaderCell literalLabel="Actions"/>
      </c:if>
    </tr>
    <c:if test="${not inquiry and not readOnlyRole}">
      <tr>
        <th class="infoline">
          <c:out value="Add:"/>
        </th>
        <c:forEach var="attrDefn" items="${role.definitions}" varStatus="status1">
          <c:set var="attr" value="${attrDefn.attributeField}"/>
          <c:set var="fieldName" value="${attr.name}"/>
          <c:set var="attrEntry" value="${role.attributeEntry[fieldName]}"/>
          <c:set var="attrDefinition" value="${role.definitionsKeyedByAttributeName[fieldName]}"/>
          <td align="left" valign="middle">
            <div align="center">
              <kul:htmlControlAttribute
                      property="document.roles[${roleIdx}].newRolePrncpl.qualifiers[${status1.index}].attrVal"
                      attributeEntry="${attrEntry}" readOnly="${readOnlyRole}"/>
                <%--
                       TODO: code (probably) does not pull the remote property name properly
                       TODO: code does not handle multiple lookup/conversion parameters
                       --%>
              <c:forEach var="widget" items="${attrDefn.attributeField.widgets}">
                <c:if test="${widget['class'].name == 'org.kuali.rice.core.api.uif.RemotableQuickFinder'}">
                  <c:if test="${!empty widget.dataObjectClass and not readOnlyRole}">
                    <kim:attributeLookup attributeDefinitions="${role.definitions}"
                                         pathPrefix="document.roles[${roleIdx}].newRolePrncpl" attr="${widget}"/>
                  </c:if>
                </c:if>
              </c:forEach>
            </div>
              <%--
               Field: ${fieldName}<br />
               Attribute Definition: ${attr}<br />
               --%>
          </td>
        </c:forEach>
        <td>
          <div align="center">
            <kul:htmlControlAttribute property="document.roles[${roleIdx}].newRolePrncpl.activeFromDate"
                                      attributeEntry="${docRolePrncplAttributes.activeFromDate}" datePicker="true"
                                      readOnly="${readOnlyRole}"/>
          </div>
        </td>
        <td>
          <div align="center">
            <kul:htmlControlAttribute property="document.roles[${roleIdx}].newRolePrncpl.activeToDate"
                                      attributeEntry="${docRolePrncplAttributes.activeToDate}" datePicker="true"
                                      readOnly="${readOnlyRole}"/>
          </div>
        </td>
        <td class="infoline">
          <div align=center>
            <kul:kualiButton property="methodToCall.addRoleQualifier.line${roleIdx}.anchor${tabKey}"
                        src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
                        label="Add" title="Add Role Qualifier" styleClass="tinybutton small outline"/>
          </div>
        </td>
      </tr>
    </c:if>
    <!-- use definitions map -->
    <c:if test="${fn:length(role.rolePrncpls) > 0}">
      <c:forEach var="rolePrncpl" items="${role.rolePrncpls}" varStatus="status1">
        <c:if test="${fn:length(rolePrncpl.qualifiers) > 0}">
          <tr>
              <%-- TODO : rowspan=2 if there is responsibilityaction only --%>
            <c:set var="rows" value="1"/>
            <c:if test="${fn:length(rolePrncpl.roleRspActions) > 0}">
              <c:set var="rows" value="2"/>

            </c:if>
            <th rowspan="${rows}" class="infoline">
              <c:out value="${status1.index+1}"/>
            </th>
            <c:forEach var="attrDefn" items="${role.definitions}" varStatus="status">
              <c:forEach var="qualifier" items="${rolePrncpl.qualifiers}" varStatus="status2">
                <c:if test="${attrDefn.attributeField.name == qualifier.kimAttribute.attributeName}">
                  <c:set var="attr" value="${attrDefn.attributeField}"/>
                  <c:set var="fieldName" value="${attr.name}"/>
                  <c:set var="attrEntry" value="${role.attributeEntry[fieldName]}"/>
                  <c:set var="attrDefinition" value="${role.definitionsKeyedByAttributeName[fieldName]}"/>
                  <c:set var="attrReadOnly" value="${readOnlyRole}"/>
                  <td align="left" valign="middle">
                    <div align="center">
                      <kul:htmlControlAttribute
                              property="document.roles[${roleIdx}].rolePrncpls[${status1.index}].qualifiers[${status.index}].attrVal"
                              attributeEntry="${attrEntry}" readOnly="true"/>


                    </div>
                  </td>
                </c:if>
              </c:forEach>
            </c:forEach>
            <kim:cell inquiry="${inquiry}" textAlign="center"
                      property="document.roles[${roleIdx}].rolePrncpls[${status1.index}].activeFromDate"
                      attributeEntry="${docRolePrncplAttributes.activeFromDate}" datePicker="true"
                      readOnly="${readOnlyRole}"/>
            <kim:cell inquiry="${inquiry}" textAlign="center"
                      property="document.roles[${roleIdx}].rolePrncpls[${status1.index}].activeToDate"
                      attributeEntry="${docRolePrncplAttributes.activeToDate}" datePicker="true"
                      readOnly="${readOnlyRole}"/>

            <c:if test="${not inquiry}">
              <td class="infoline">
                <div align=center>
                 <c:if test="${!readOnlyRole}">
                   <kul:kualiButton property="methodToCall.deleteRoleQualifier.line${roleIdx}:${status1.index}.anchor${currentTabIndex}"
                                    src="${ConfigProperties.kr.externalizable.images.url}tinybutton-inactivate.gif"
                                    label="Inactivate" title="Inactivate Role Qualifier" styleClass="tinybutton small outline"/>
                  </c:if>
                </div>
              </td>
            </c:if>
          </tr>
          <c:if test="${fn:length(rolePrncpl.roleRspActions) > 0}">
            <tr>
              <td colspan="12" style="padding:0px;">
                <kim:roleResponsibilityAction roleIdx="${roleIdx}" mbrIdx="${status1.index}"/>
              </td>
            </tr>
          </c:if>
        </c:if>
      </c:forEach>
      <tr>
        <!-- need to decide colspan -->
        <td colspan="15" style="padding:0px; border-style:none; height:22px; background-color:#F6F6F6">&nbsp;</td>
      </tr>
    </c:if>
  </table>
</kul:subtab>
