<#--
 #%L
 %%
 Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#-- Can be called by templates that are building HTML tags to build the standard attributes
such as class and style. This tag checks whether the component actually
has a value for these settings before building up the attribute. This makes the outputted html
cleaner and actually prevents problems from having any empty attribute value in some cases (like
for style. The attribute strings can be referenced by the calling template through the exported
variables -->

<#function attrBuild component>
	<#-- NOTICE: By KULRICE-10353 this method is duplicated, but not replaced, by
			org.kuali.rice.krad.uif.freemarker.FreeMarkerInlineRenderUtils.renderAttrBuild().
			When updating this template, also update that method. -->

    <#if component.cssClasses?has_content>
        <#local styleClass="class=\"${component.styleClassesAsString}\""/>
    </#if>

    <#if component.style?has_content>
        <#local style="style=\"${component.style}\""/>
    </#if>

    <#if component.title?has_content>
        <#local title="title=\"${component.title}\""/>
    </#if>

    <#if component.role?has_content>
        <#local role="role=\"${component.role}\""/>
    </#if>

    <#if component.ariaAttributes?has_content>
        <#local ariaAttributes="${component.ariaAttributesAsString}"/>
    </#if>

    <#return "${styleClass!} ${style!} ${title!} ${role!} ${ariaAttributes!}">

</#function>
