<#--
 #%L
 %%
 Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#--
    Box Layout Manager:

      Places each component of the given list into a horizontal or vertical row.

      The amount of padding is configured by the 'padding'
      property of the layout manager. The padding is implemented by setting the margin of the wrapping
      span style. For vertical orientation, the span style is set to block.
 -->

<#macro uif_box items manager container>

    <#if manager.styleClassesAsString?has_content>
        <#local styleClass="class=\"${manager.styleClassesAsString}\""/>
    </#if>

    <#if manager.style?has_content>
        <#local style="style=\"${manager.style}\""/>
    </#if>

    <#if manager.renderLayoutWrapper>
       <div id="${manager.id}" ${style!} ${styleClass!}>
    </#if>

    <#list items as item>
        <@krad.template component=item/>
    </#list>

    <#if manager.renderLayoutWrapper>
       </div>
    </#if>

</#macro>
