<%--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<c:set var="docEmailAttributes" value="${DataDictionary.PersonDocumentEmail.attributes}" />

<c:set var="canModify" scope="request" value="${!KualiForm.document.privacy.suppressEmail || KualiForm.canOverrideEntityPrivacyPreferences}" />
<c:set var="maskData" value="${KualiForm.document.privacy.suppressEmail && !KualiForm.canOverrideEntityPrivacyPreferences}" />

<kul:subtab lookedUpCollectionName="email" width="${tableWidth}" subTabTitle="Email Addresses" noShowHideButton="true">      
    <table cellpadding="0" cellspacing="0" summary="">
        <tr>
            <th>&nbsp;</th> 
            <th><div align="center"><kul:htmlAttributeLabel attributeEntry="${docEmailAttributes.emailAddress}" noColon="true" /></div></th>
            <th><div align="center"><kul:htmlAttributeLabel attributeEntry="${docEmailAttributes.emailTypeCode}" noColon="true" /></div></th>
            <th><div align="center"><kul:htmlAttributeLabel attributeEntry="${docEmailAttributes.dflt}" noColon="true" /></div></th>
            <th><div align="center"><kul:htmlAttributeLabel attributeEntry="${docEmailAttributes.active}" noColon="true" /></div></th>
            <c:if test="${not inquiry and canModify}">  
                <kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
            </c:if>
        </tr>     
        <c:if test="${not inquiry and not readOnlyEntity and canModify}">
            <tr>
                <th class="infoline">Add:</th>
                <td class="infoline">   
                <div align="center">                
                  <kul:htmlControlAttribute property="newEmail.emailAddress" attributeEntry="${docEmailAttributes.emailAddress}" readOnly="${readOnlyEntity}" />
                </div>
                </td>
                <td align="left" valign="middle" class="infoline">
                <div align="center">
                    <kul:htmlControlAttribute property="newEmail.emailTypeCode" attributeEntry="${docEmailAttributes.emailTypeCode}" readOnly="${readOnlyEntity}" />
                </div>
                </td>
                <td class="infoline">   
                <div align="center">                
                  <kul:htmlControlAttribute property="newEmail.dflt" attributeEntry="${docEmailAttributes.dflt}" readOnly="${readOnlyEntity}" />
                </div>
                </td>
                <td class="infoline">   
                <div align="center">                
                  <kul:htmlControlAttribute property="newEmail.active" attributeEntry="${docEmailAttributes.active}" readOnly="${readOnlyEntity}" />
                </div>
                </td>                                
                <td class="infoline">
                    <div align=center>
                        <kul:kualiButton property="methodToCall.addEmail.anchor${tabKey}"
                                    src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
                                    label="Add" title="Add Email" styleClass="tinybutton small outline"/>
                    </div>
                </td>
            </tr>         
        </c:if>        
        <c:forEach var="email" items="${KualiForm.document.emails}" varStatus="status">
            <c:if test="${!(inquiry and readOnlyEntity and kfunc:isHiddenKimObjectType(email.emailType.code, 'kim.hide.PersonDocumentEmail.type'))}">
              <tr>
                <th class="infoline">
                    <c:out value="${status.index+1}" />
                </th>
                <td>     
                    <div align="center">            
                      <kul:htmlControlAttribute property="document.emails[${status.index}].emailAddress" attributeEntry="${docEmailAttributes.emailAddress}" readOnly="${readOnlyEntity or !canModify}" displayMask="${maskData}" displayMaskValue="xxxxx@xxx.xxx" />
                    </div>
                </td>
                <td align="left" valign="middle">
                    <div align="center"> <kul:htmlControlAttribute property="document.emails[${status.index}].emailTypeCode"  attributeEntry="${docEmailAttributes.emailTypeCode}"  readOnlyAlternateDisplay="${fn:escapeXml(email.emailType.name)}" readOnly="${readOnlyEntity or !canModify}" />
                    </div>
                </td>
                <td>
                    <div align="center">            
                      <kul:htmlControlAttribute property="document.emails[${status.index}].dflt" attributeEntry="${docEmailAttributes.dflt}" readOnly="${readOnlyEntity or !canModify}" />
                    </div>
                </td>
                <td>
                    <div align="center">            
                      <kul:htmlControlAttribute property="document.emails[${status.index}].active" attributeEntry="${docEmailAttributes.active}" readOnly="${readOnlyEntity or !canModify}" />
                    </div>
                </td>
                <c:if test="${not inquiry and canModify}">                      
                    <td>
                        <div align="center">&nbsp;
                            <kul:kualiButton property="methodToCall.deleteEmail.line${status.index}.anchor${currentTabIndex}"
                                             src="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete1.gif"
                                             disabledSrc="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete2.gif"
                                             label="Delete" title="Delete Email" styleClass="tinybutton small outline"
                                             disabled="${email.edit or readOnlyEntity}" />
                        </div>
                    </td>
                </c:if>    
              </tr>
            </c:if>  
        </c:forEach>                    
    </table>
</kul:subtab>
