/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.sql.SQLException;
import java.util.List;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.autogeneratedkey.NoAutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.executor.QueryExecutor;
import org.mule.module.db.internal.domain.executor.QueryExecutorFactory;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.processor.AbstractSingleQueryDbMessageProcessor;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.query.QueryResolver;

public class UpdateMessageProcessor
extends AbstractSingleQueryDbMessageProcessor {
    private AutoGeneratedKeyStrategy autoGeneratedKeyStrategy;
    private final QueryExecutorFactory queryExecutorFactory;
    private final List<QueryType> validQueryTypes;

    public UpdateMessageProcessor(DbConfigResolver dbConfigResolver, QueryResolver queryResolver, QueryExecutorFactory queryExecutorFactory, TransactionalAction transactionalAction, List<QueryType> validQueryTypes) {
        super(dbConfigResolver, queryResolver, transactionalAction);
        this.queryExecutorFactory = queryExecutorFactory;
        this.validQueryTypes = validQueryTypes;
        this.autoGeneratedKeyStrategy = new NoAutoGeneratedKeyStrategy();
    }

    @Override
    protected List<QueryType> getValidQueryTypes() {
        return this.validQueryTypes;
    }

    @Override
    protected Object doExecuteQuery(DbConnection connection, Query query) throws SQLException {
        QueryExecutor queryExecutor = this.queryExecutorFactory.create();
        return queryExecutor.execute(connection, query, this.autoGeneratedKeyStrategy);
    }

    public AutoGeneratedKeyStrategy getAutoGeneratedKeyStrategy() {
        return this.autoGeneratedKeyStrategy;
    }

    public void setAutoGeneratedKeyStrategy(AutoGeneratedKeyStrategy autoGeneratedKeyStrategy) {
        this.autoGeneratedKeyStrategy = autoGeneratedKeyStrategy;
    }
}

