/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.internal.operation;

import com.saxonica.xqj.SaxonXQDataSource;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQResultSequence;
import net.sf.saxon.Configuration;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.mule.module.xml.internal.XmlModule;
import org.mule.module.xml.internal.error.StandardXmlErrorTypeProvider;
import org.mule.module.xml.internal.error.TransformationException;
import org.mule.module.xml.internal.operation.PooledTransformerOperation;
import org.mule.module.xml.internal.util.XMLUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XQueryOperation
extends PooledTransformerOperation<String, XQPreparedExpression> {
    private static final String SOURCE_DOCUMENT_NAMESPACE = "document";
    private static final Logger LOGGER = LoggerFactory.getLogger(XQueryOperation.class);
    private XQConnection connection;
    private XQItemType stringType;
    private ThreadLocal<Map<String, Object>> currentContext = new ThreadLocal();

    @Override
    protected void doInitialise() throws InitialisationException {
        SaxonXQDataSource ds = new SaxonXQDataSource(new Configuration());
        try {
            this.connection = ds.getConnection();
            this.stringType = this.connection.createAtomicType(29);
        }
        catch (Exception e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Could not initialise XQuery DataSource"), (Throwable)e, (Initialisable)this);
        }
    }

    @Execution(value=ExecutionType.CPU_INTENSIVE)
    @Throws(value={StandardXmlErrorTypeProvider.class})
    public List<String> xqueryTransform(@Content(primary=true) InputStream content, @Text String xquery, @Optional @Content @NullSafe Map<String, Object> contextProperties, @Config XmlModule config) {
        return (List)this.withTransformer(xquery, transformer -> {
            this.bindParameters((XQPreparedExpression)transformer, contextProperties);
            this.currentContext.set(contextProperties);
            transformer.bindNode(new QName(SOURCE_DOCUMENT_NAMESPACE), XMLUtils.toDOMNode(content, this.documentBuilderFactory), this.connection.createNodeType());
            XQResultSequence result = transformer.executeQuery();
            LinkedList<String> results = new LinkedList<String>();
            while (result.next()) {
                XQItem item = result.getItem();
                results.add(item.getItemAsString(null));
            }
            return results;
        });
    }

    private void unbindParameters(@Content @NullSafe Map<String, Object> contextProperties, XQPreparedExpression transformer) {
        contextProperties.forEach((key, value) -> {
            try {
                transformer.bindAtomicValue(new QName((String)key), "", this.stringType);
            }
            catch (XQException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void bindParameters(XQPreparedExpression transformer, Map<String, Object> contextProperties) {
        contextProperties.forEach((key, value) -> {
            block11: {
                QName paramKey = new QName((String)key);
                try {
                    if (value instanceof InputStream) {
                        this.bindStringParameter(transformer, IOUtils.toString((InputStream)((InputStream)value)), paramKey);
                        break block11;
                    }
                    if (value instanceof String) {
                        this.bindStringParameter(transformer, value, paramKey);
                        break block11;
                    }
                    if (value instanceof Boolean) {
                        transformer.bindBoolean(paramKey, ((Boolean)value).booleanValue(), this.connection.createAtomicType(10));
                        break block11;
                    }
                    if (value instanceof Byte) {
                        transformer.bindByte(paramKey, ((Byte)value).byteValue(), this.connection.createAtomicType(31));
                        break block11;
                    }
                    if (value instanceof Short) {
                        transformer.bindShort(paramKey, ((Short)value).shortValue(), this.connection.createAtomicType(14));
                        break block11;
                    }
                    if (value instanceof Integer) {
                        transformer.bindInt(paramKey, ((Integer)value).intValue(), this.connection.createAtomicType(12));
                        break block11;
                    }
                    if (value instanceof Long) {
                        transformer.bindLong(paramKey, ((Long)value).longValue(), this.connection.createAtomicType(15));
                        break block11;
                    }
                    if (value instanceof Float) {
                        transformer.bindFloat(paramKey, ((Float)value).floatValue(), this.connection.createAtomicType(20));
                        break block11;
                    }
                    if (value instanceof Double) {
                        transformer.bindDouble(paramKey, ((Double)value).doubleValue(), this.connection.createAtomicType(18));
                        break block11;
                    }
                    throw new TransformationException(String.format("Cannot bind value for key '%s' because type '%s' is not supported", key, value.getClass().getName()));
                }
                catch (Exception e) {
                    throw new TransformationException("Failed to bind parameters for XQuery transformation. " + e.getMessage(), e);
                }
            }
        });
    }

    private void bindStringParameter(XQPreparedExpression transformer, Object value, QName paramKey) throws XQException {
        transformer.bindAtomicValue(paramKey, value.toString(), this.connection.createAtomicType(29));
    }

    @Override
    protected BasePooledObjectFactory<XQPreparedExpression> createPooledObjectFactory(final String xquery) {
        return new BasePooledObjectFactory<XQPreparedExpression>(){

            public XQPreparedExpression create() throws Exception {
                return XQueryOperation.this.connection.prepareExpression(xquery);
            }

            public void destroyObject(PooledObject<XQPreparedExpression> p) throws Exception {
                ((XQPreparedExpression)p.getObject()).close();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean validateObject(PooledObject<XQPreparedExpression> p) {
                try {
                    Map contextProperties = (Map)XQueryOperation.this.currentContext.get();
                    XQueryOperation.this.unbindParameters(contextProperties, (XQPreparedExpression)p.getObject());
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Found exception unbinding parameters. Transformer will be dropped", (Throwable)e);
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    XQueryOperation.this.currentContext.remove();
                }
            }

            public PooledObject<XQPreparedExpression> wrap(XQPreparedExpression obj) {
                return new DefaultPooledObject((Object)obj);
            }
        };
    }

    @Override
    protected boolean testOnReturn() {
        return true;
    }
}

