/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: XAException.java 1506 2007-06-30 15:34:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.transaction.xa;

/**
 * The XAException is thrown by the Resource Manager (RM)
 * to inform the Transaction Manager of an error encountered
 * by the involved transaction.
 * @author Guillaume Sauthier
 */
public class XAException extends Exception {

    /**
     * Serial Version UID.
     * TODO Check for interoperability.
     */
    private static final long serialVersionUID = -8249683284832867751L;

    /**
     * The error code with which to create the SystemException.
     */
    public int errorCode;

    /**
     * The inclusive lower bound of the rollback codes.
     */
    public static final int XA_RBBASE = 100;

    /**
     * Indicates that the rollback was caused by an unspecified reason.
     */
    public static final int XA_RBROLLBACK = 100;

    /**
     * Indicates that the rollback was caused by a communication failure.
     */
    public static final int XA_RBCOMMFAIL = 101;

    /**
     * A deadlock was detected.
     */
    public static final int XA_RBDEADLOCK = 102;

    /**
     * A condition that violates the integrity of the resource was detected.
     */
    public static final int XA_RBINTEGRITY = 103;

    /**
     * The resource manager rolled back the transaction branch for
     * a reason not on this list.
     */
    public static final int XA_RBOTHER = 104;

    /**
     * A protocol error occurred in the resource manager.
     */
    public static final int XA_RBPROTO = 105;

    /**
     * A transaction branch took too long.
     */
    public static final int XA_RBTIMEOUT = 106;

    /**
     * May retry the transaction branch.
     */
    public static final int XA_RBTRANSIENT = 107;

    /**
     * The inclusive upper bound of the rollback error code.
     */
    public static final int XA_RBEND = 107;

    /**
     * Resumption must occur where the suspension occurred.
     */
    public static final int XA_NOMIGRATE = 9;

    /**
     * The transaction branch may have been heuristically completed.
     */
    public static final int XA_HEURHAZ = 8;

    /**
     * The transaction branch has been heuristically committed.
     */
    public static final int XA_HEURCOM = 7;

    /**
     * The transaction branch has been heuristically rolled back.
     */
    public static final int XA_HEURRB = 6;

    /**
     * The transaction branch has been heuristically committed and rolled back.
     */
    public static final int XA_HEURMIX = 5;

    /**
     * Routine returned with no effect and may be reissued.
     */
    public static final int XA_RETRY = 4;

    /**
     * The transaction branch was read-only and has been committed.
     */
    public static final int XA_RDONLY = 3;

    /**
     * There is an asynchronous operation already outstanding.
     */
    public static final int XAER_ASYNC = -2;

    /**
     * A resource manager error has occurred in the transaction branch.
     */
    public static final int XAER_RMERR = -3;

    /**
     * The XID is not valid.
     */
    public static final int XAER_NOTA = -4;

    /**
     * Invalid arguments were given.
     */
    public static final int XAER_INVAL = -5;

    /**
     * Routine was invoked in an improper context.
     */
    public static final int XAER_PROTO = -6;

    /**
     * Resource manager is unavailable.
     */
    public static final int XAER_RMFAIL = -7;

    /**
     * The XID already exists.
     */
    public static final int XAER_DUPID = -8;

    /**
     * The resource manager is doing work outside a global transaction.
     */
    public static final int XAER_OUTSIDE = -9;

    /**
     * Create an XAException.
     */
    public XAException() {
        // TODO What is the default errorCode value ?
    }

    /**
     * Create an XAException with a given error code.
     * @param errcode The error code identifying the exception.
     */
    public XAException(int errcode) {
        super();
        this.errorCode = errcode;
    }

    /**
     * Create an XAException with a given string.
     * @param s The {@link String} object containing the exception message.
     */
    public XAException(String s) {
        super(s);
    }

}
