/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationResult;

public final class MutationMetaData {
    private final List<MutationResult> mutations;

    public MutationMetaData(List<MutationResult> mutations) {
        this.mutations = mutations;
    }

    public Collection<MutationResult> getMutations() {
        return this.mutations;
    }

    public Collection<ClassMutationResults> toClassResults() {
        Collections.sort(this.mutations, MutationMetaData.comparator());
        ArrayList<ClassMutationResults> cmrs = new ArrayList<ClassMutationResults>();
        ArrayList<MutationResult> buffer = new ArrayList<MutationResult>();
        ClassName cn = null;
        for (MutationResult each : this.mutations) {
            if (cn != null && !each.getDetails().getClassName().equals((Object)cn)) {
                cmrs.add(new ClassMutationResults(buffer));
                buffer.clear();
            }
            cn = each.getDetails().getClassName();
            buffer.add(each);
        }
        if (!buffer.isEmpty()) {
            cmrs.add(new ClassMutationResults(buffer));
        }
        return cmrs;
    }

    private static Comparator<MutationResult> comparator() {
        return (arg0, arg1) -> arg0.getDetails().getId().compareTo(arg1.getDetails().getId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mutations == null ? 0 : this.mutations.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutationMetaData other = (MutationMetaData)obj;
        return !(this.mutations == null ? other.mutations != null : !this.mutations.equals(other.mutations));
    }
}

