/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springdoc.core.SpringDocConfiguration;
import org.springdoc.core.SpringDocPropertiesUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
@ConfigurationProperties(prefix="springdoc.swagger-ui.oauth")
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SwaggerUiOAuthProperties {
    private String clientId;
    private String clientSecret;
    private String realm;
    private String appName;
    private String scopeSeparator;
    private Map<String, String> additionalQueryStringParams;
    private String useBasicAuthenticationWithAccessCodeGrant;
    private Boolean usePkceWithAuthorizationCodeGrant;
    private List<String> scopes;

    public Map<String, Object> getConfigParameters() {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        SpringDocPropertiesUtils.put("clientId", this.clientId, params);
        SpringDocPropertiesUtils.put("clientSecret", this.clientSecret, params);
        SpringDocPropertiesUtils.put("realm", this.realm, params);
        SpringDocPropertiesUtils.put("scopeSeparator", this.scopeSeparator, params);
        SpringDocPropertiesUtils.put("appName", this.appName, params);
        if (!CollectionUtils.isEmpty(this.scopes)) {
            SpringDocPropertiesUtils.put("scopes", String.join((CharSequence)" ", this.scopes), params);
        }
        SpringDocPropertiesUtils.put("useBasicAuthenticationWithAccessCodeGrant", this.useBasicAuthenticationWithAccessCodeGrant, params);
        SpringDocPropertiesUtils.put("usePkceWithAuthorizationCodeGrant", this.usePkceWithAuthorizationCodeGrant, params);
        SpringDocPropertiesUtils.put("additionalQueryStringParams", this.additionalQueryStringParams, params);
        return params;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getScopeSeparator() {
        return this.scopeSeparator;
    }

    public void setScopeSeparator(String scopeSeparator) {
        this.scopeSeparator = scopeSeparator;
    }

    public Map<String, String> getAdditionalQueryStringParams() {
        return this.additionalQueryStringParams;
    }

    public void setAdditionalQueryStringParams(Map<String, String> additionalQueryStringParams) {
        this.additionalQueryStringParams = additionalQueryStringParams;
    }

    public String getUseBasicAuthenticationWithAccessCodeGrant() {
        return this.useBasicAuthenticationWithAccessCodeGrant;
    }

    public void setUseBasicAuthenticationWithAccessCodeGrant(String useBasicAuthenticationWithAccessCodeGrant) {
        this.useBasicAuthenticationWithAccessCodeGrant = useBasicAuthenticationWithAccessCodeGrant;
    }

    public Boolean getUsePkceWithAuthorizationCodeGrant() {
        return this.usePkceWithAuthorizationCodeGrant;
    }

    public void setUsePkceWithAuthorizationCodeGrant(Boolean usePkceWithAuthorizationCodeGrant) {
        this.usePkceWithAuthorizationCodeGrant = usePkceWithAuthorizationCodeGrant;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }
}

