/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters;

import com.netflix.hystrix.HystrixCommandProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="zuul")
public class ZuulProperties {
    public static final List<String> SECURITY_HEADERS = Arrays.asList("Pragma", "Cache-Control", "X-Frame-Options", "X-Content-Type-Options", "X-XSS-Protection", "Expires");
    private String prefix = "";
    private boolean stripPrefix = true;
    private Boolean retryable = false;
    private Map<String, ZuulRoute> routes = new LinkedHashMap<String, ZuulRoute>();
    private boolean addProxyHeaders = true;
    private boolean addHostHeader = false;
    private Set<String> ignoredServices = new LinkedHashSet<String>();
    private Set<String> ignoredPatterns = new LinkedHashSet<String>();
    private Set<String> ignoredHeaders = new LinkedHashSet<String>();
    private boolean ignoreSecurityHeaders = true;
    private boolean forceOriginalQueryStringEncoding = false;
    private String servletPath = "/zuul";
    private boolean ignoreLocalService = true;
    private Host host = new Host();
    private boolean traceRequestBody = true;
    private boolean removeSemicolonContent = true;
    private Set<String> sensitiveHeaders = new LinkedHashSet<String>(Arrays.asList("Cookie", "Set-Cookie", "Authorization"));
    private boolean sslHostnameValidationEnabled = true;
    private HystrixCommandProperties.ExecutionIsolationStrategy ribbonIsolationStrategy = HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE;
    private HystrixSemaphore semaphore = new HystrixSemaphore();
    private HystrixThreadPool threadPool = new HystrixThreadPool();
    private boolean setContentLength = false;
    private boolean includeDebugHeader = false;
    private int initialStreamBufferSize = 8192;

    public Set<String> getIgnoredHeaders() {
        LinkedHashSet<String> ignoredHeaders = new LinkedHashSet<String>(this.ignoredHeaders);
        if (ClassUtils.isPresent((String)"org.springframework.security.config.annotation.web.WebSecurityConfigurer", null) && Collections.disjoint(ignoredHeaders, SECURITY_HEADERS) && this.ignoreSecurityHeaders) {
            ignoredHeaders.addAll(SECURITY_HEADERS);
        }
        return ignoredHeaders;
    }

    public void setIgnoredHeaders(Set<String> ignoredHeaders) {
        this.ignoredHeaders.addAll(ignoredHeaders);
    }

    @PostConstruct
    public void init() {
        for (Map.Entry<String, ZuulRoute> entry : this.routes.entrySet()) {
            ZuulRoute value = entry.getValue();
            if (!StringUtils.hasText((String)value.getLocation())) {
                value.serviceId = entry.getKey();
            }
            if (!StringUtils.hasText((String)value.getId())) {
                value.id = entry.getKey();
            }
            if (StringUtils.hasText((String)value.getPath())) continue;
            value.path = "/" + entry.getKey() + "/**";
        }
    }

    public String getServletPattern() {
        String path = this.servletPath;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.contains("*")) {
            path = path.endsWith("/") ? path + "*" : path + "/*";
        }
        return path;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isStripPrefix() {
        return this.stripPrefix;
    }

    public void setStripPrefix(boolean stripPrefix) {
        this.stripPrefix = stripPrefix;
    }

    public Boolean getRetryable() {
        return this.retryable;
    }

    public void setRetryable(Boolean retryable) {
        this.retryable = retryable;
    }

    public Map<String, ZuulRoute> getRoutes() {
        return this.routes;
    }

    public void setRoutes(Map<String, ZuulRoute> routes) {
        this.routes = routes;
    }

    public boolean isAddProxyHeaders() {
        return this.addProxyHeaders;
    }

    public void setAddProxyHeaders(boolean addProxyHeaders) {
        this.addProxyHeaders = addProxyHeaders;
    }

    public boolean isAddHostHeader() {
        return this.addHostHeader;
    }

    public void setAddHostHeader(boolean addHostHeader) {
        this.addHostHeader = addHostHeader;
    }

    public Set<String> getIgnoredServices() {
        return this.ignoredServices;
    }

    public void setIgnoredServices(Set<String> ignoredServices) {
        this.ignoredServices = ignoredServices;
    }

    public Set<String> getIgnoredPatterns() {
        return this.ignoredPatterns;
    }

    public void setIgnoredPatterns(Set<String> ignoredPatterns) {
        this.ignoredPatterns = ignoredPatterns;
    }

    public boolean isIgnoreSecurityHeaders() {
        return this.ignoreSecurityHeaders;
    }

    public void setIgnoreSecurityHeaders(boolean ignoreSecurityHeaders) {
        this.ignoreSecurityHeaders = ignoreSecurityHeaders;
    }

    public boolean isForceOriginalQueryStringEncoding() {
        return this.forceOriginalQueryStringEncoding;
    }

    public void setForceOriginalQueryStringEncoding(boolean forceOriginalQueryStringEncoding) {
        this.forceOriginalQueryStringEncoding = forceOriginalQueryStringEncoding;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public boolean isIgnoreLocalService() {
        return this.ignoreLocalService;
    }

    public void setIgnoreLocalService(boolean ignoreLocalService) {
        this.ignoreLocalService = ignoreLocalService;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public boolean isTraceRequestBody() {
        return this.traceRequestBody;
    }

    public void setTraceRequestBody(boolean traceRequestBody) {
        this.traceRequestBody = traceRequestBody;
    }

    public boolean isRemoveSemicolonContent() {
        return this.removeSemicolonContent;
    }

    public void setRemoveSemicolonContent(boolean removeSemicolonContent) {
        this.removeSemicolonContent = removeSemicolonContent;
    }

    public Set<String> getSensitiveHeaders() {
        return this.sensitiveHeaders;
    }

    public void setSensitiveHeaders(Set<String> sensitiveHeaders) {
        this.sensitiveHeaders = sensitiveHeaders;
    }

    public boolean isSslHostnameValidationEnabled() {
        return this.sslHostnameValidationEnabled;
    }

    public void setSslHostnameValidationEnabled(boolean sslHostnameValidationEnabled) {
        this.sslHostnameValidationEnabled = sslHostnameValidationEnabled;
    }

    public HystrixCommandProperties.ExecutionIsolationStrategy getRibbonIsolationStrategy() {
        return this.ribbonIsolationStrategy;
    }

    public void setRibbonIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy ribbonIsolationStrategy) {
        this.ribbonIsolationStrategy = ribbonIsolationStrategy;
    }

    public HystrixSemaphore getSemaphore() {
        return this.semaphore;
    }

    public void setSemaphore(HystrixSemaphore semaphore) {
        this.semaphore = semaphore;
    }

    public HystrixThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(HystrixThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public boolean isSetContentLength() {
        return this.setContentLength;
    }

    public void setSetContentLength(boolean setContentLength) {
        this.setContentLength = setContentLength;
    }

    public boolean isIncludeDebugHeader() {
        return this.includeDebugHeader;
    }

    public void setIncludeDebugHeader(boolean includeDebugHeader) {
        this.includeDebugHeader = includeDebugHeader;
    }

    public int getInitialStreamBufferSize() {
        return this.initialStreamBufferSize;
    }

    public void setInitialStreamBufferSize(int initialStreamBufferSize) {
        this.initialStreamBufferSize = initialStreamBufferSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZuulProperties that = (ZuulProperties)o;
        return this.addHostHeader == that.addHostHeader && this.addProxyHeaders == that.addProxyHeaders && this.forceOriginalQueryStringEncoding == that.forceOriginalQueryStringEncoding && Objects.equals(this.host, that.host) && Objects.equals(this.ignoredHeaders, that.ignoredHeaders) && Objects.equals(this.ignoredPatterns, that.ignoredPatterns) && Objects.equals(this.ignoredServices, that.ignoredServices) && this.ignoreLocalService == that.ignoreLocalService && this.ignoreSecurityHeaders == that.ignoreSecurityHeaders && Objects.equals(this.prefix, that.prefix) && this.removeSemicolonContent == that.removeSemicolonContent && Objects.equals(this.retryable, that.retryable) && Objects.equals(this.ribbonIsolationStrategy, that.ribbonIsolationStrategy) && Objects.equals(this.routes, that.routes) && Objects.equals(this.semaphore, that.semaphore) && Objects.equals(this.sensitiveHeaders, that.sensitiveHeaders) && Objects.equals(this.servletPath, that.servletPath) && this.sslHostnameValidationEnabled == that.sslHostnameValidationEnabled && this.stripPrefix == that.stripPrefix && this.setContentLength == that.setContentLength && this.includeDebugHeader == that.includeDebugHeader && this.initialStreamBufferSize == that.initialStreamBufferSize && Objects.equals(this.threadPool, that.threadPool) && this.traceRequestBody == that.traceRequestBody;
    }

    public int hashCode() {
        return Objects.hash(this.addHostHeader, this.addProxyHeaders, this.forceOriginalQueryStringEncoding, this.host, this.ignoredHeaders, this.ignoredPatterns, this.ignoredServices, this.ignoreLocalService, this.ignoreSecurityHeaders, this.prefix, this.removeSemicolonContent, this.retryable, this.ribbonIsolationStrategy, this.routes, this.semaphore, this.sensitiveHeaders, this.servletPath, this.sslHostnameValidationEnabled, this.stripPrefix, this.threadPool, this.traceRequestBody, this.setContentLength, this.includeDebugHeader, this.initialStreamBufferSize);
    }

    public String toString() {
        return "ZuulProperties{" + "prefix='" + this.prefix + "', " + "stripPrefix=" + this.stripPrefix + ", " + "retryable=" + this.retryable + ", " + "routes=" + this.routes + ", " + "addProxyHeaders=" + this.addProxyHeaders + ", " + "addHostHeader=" + this.addHostHeader + ", " + "ignoredServices=" + this.ignoredServices + ", " + "ignoredPatterns=" + this.ignoredPatterns + ", " + "ignoredHeaders=" + this.ignoredHeaders + ", " + "ignoreSecurityHeaders=" + this.ignoreSecurityHeaders + ", " + "forceOriginalQueryStringEncoding=" + this.forceOriginalQueryStringEncoding + ", " + "servletPath='" + this.servletPath + "', " + "ignoreLocalService=" + this.ignoreLocalService + ", " + "host=" + this.host + ", " + "traceRequestBody=" + this.traceRequestBody + ", " + "removeSemicolonContent=" + this.removeSemicolonContent + ", " + "sensitiveHeaders=" + this.sensitiveHeaders + ", " + "sslHostnameValidationEnabled=" + this.sslHostnameValidationEnabled + ", " + "ribbonIsolationStrategy=" + this.ribbonIsolationStrategy + ", " + "semaphore=" + this.semaphore + ", " + "threadPool=" + this.threadPool + ", " + "setContentLength=" + this.setContentLength + ", " + "includeDebugHeader=" + this.includeDebugHeader + ", " + "initialStreamBufferSize=" + this.initialStreamBufferSize + ", " + "}";
    }

    public static class HystrixThreadPool {
        private boolean useSeparateThreadPools = false;
        private String threadPoolKeyPrefix = "";

        public boolean isUseSeparateThreadPools() {
            return this.useSeparateThreadPools;
        }

        public void setUseSeparateThreadPools(boolean useSeparateThreadPools) {
            this.useSeparateThreadPools = useSeparateThreadPools;
        }

        public String getThreadPoolKeyPrefix() {
            return this.threadPoolKeyPrefix;
        }

        public void setThreadPoolKeyPrefix(String threadPoolKeyPrefix) {
            this.threadPoolKeyPrefix = threadPoolKeyPrefix;
        }
    }

    public static class HystrixSemaphore {
        private int maxSemaphores = 100;

        public HystrixSemaphore() {
        }

        public HystrixSemaphore(int maxSemaphores) {
            this.maxSemaphores = maxSemaphores;
        }

        public int getMaxSemaphores() {
            return this.maxSemaphores;
        }

        public void setMaxSemaphores(int maxSemaphores) {
            this.maxSemaphores = maxSemaphores;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HystrixSemaphore that = (HystrixSemaphore)o;
            return this.maxSemaphores == that.maxSemaphores;
        }

        public int hashCode() {
            return Objects.hash(this.maxSemaphores);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("HystrixSemaphore{");
            sb.append("maxSemaphores=").append(this.maxSemaphores);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class Host {
        private int maxTotalConnections = 200;
        private int maxPerRouteConnections = 20;
        private int socketTimeoutMillis = 10000;
        private int connectTimeoutMillis = 2000;
        private int connectionRequestTimeoutMillis = -1;
        private long timeToLive = -1L;
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

        public Host() {
        }

        public Host(int maxTotalConnections, int maxPerRouteConnections, int socketTimeoutMillis, int connectTimeoutMillis, long timeToLive, TimeUnit timeUnit) {
            this.maxTotalConnections = maxTotalConnections;
            this.maxPerRouteConnections = maxPerRouteConnections;
            this.socketTimeoutMillis = socketTimeoutMillis;
            this.connectTimeoutMillis = connectTimeoutMillis;
            this.timeToLive = timeToLive;
            this.timeUnit = timeUnit;
        }

        public int getMaxTotalConnections() {
            return this.maxTotalConnections;
        }

        public void setMaxTotalConnections(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
        }

        public int getMaxPerRouteConnections() {
            return this.maxPerRouteConnections;
        }

        public void setMaxPerRouteConnections(int maxPerRouteConnections) {
            this.maxPerRouteConnections = maxPerRouteConnections;
        }

        public int getSocketTimeoutMillis() {
            return this.socketTimeoutMillis;
        }

        public void setSocketTimeoutMillis(int socketTimeoutMillis) {
            this.socketTimeoutMillis = socketTimeoutMillis;
        }

        public int getConnectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public void setConnectTimeoutMillis(int connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
        }

        public int getConnectionRequestTimeoutMillis() {
            return this.connectionRequestTimeoutMillis;
        }

        public void setConnectionRequestTimeoutMillis(int connectionRequestTimeoutMillis) {
            this.connectionRequestTimeoutMillis = connectionRequestTimeoutMillis;
        }

        public long getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(long timeToLive) {
            this.timeToLive = timeToLive;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Host host = (Host)o;
            return this.maxTotalConnections == host.maxTotalConnections && this.maxPerRouteConnections == host.maxPerRouteConnections && this.socketTimeoutMillis == host.socketTimeoutMillis && this.connectTimeoutMillis == host.connectTimeoutMillis && this.connectionRequestTimeoutMillis == host.connectionRequestTimeoutMillis && this.timeToLive == host.timeToLive && this.timeUnit == host.timeUnit;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.maxTotalConnections, this.maxPerRouteConnections, this.socketTimeoutMillis, this.connectTimeoutMillis, this.connectionRequestTimeoutMillis, this.timeToLive, this.timeUnit});
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("maxTotalConnections", this.maxTotalConnections).append("maxPerRouteConnections", this.maxPerRouteConnections).append("socketTimeoutMillis", this.socketTimeoutMillis).append("connectTimeoutMillis", this.connectTimeoutMillis).append("connectionRequestTimeoutMillis", this.connectionRequestTimeoutMillis).append("timeToLive", this.timeToLive).append("timeUnit", (Object)this.timeUnit).toString();
        }
    }

    public static class ZuulRoute {
        private String id;
        private String path;
        private String serviceId;
        private String url;
        private boolean stripPrefix = true;
        private Boolean retryable;
        private Set<String> sensitiveHeaders = new LinkedHashSet<String>();
        private boolean customSensitiveHeaders = false;

        public ZuulRoute() {
        }

        public ZuulRoute(String id, String path, String serviceId, String url, boolean stripPrefix, Boolean retryable, Set<String> sensitiveHeaders) {
            this.id = id;
            this.path = path;
            this.serviceId = serviceId;
            this.url = url;
            this.stripPrefix = stripPrefix;
            this.retryable = retryable;
            this.sensitiveHeaders = sensitiveHeaders;
            this.customSensitiveHeaders = sensitiveHeaders != null;
        }

        public ZuulRoute(String text) {
            String location = null;
            String path = text;
            if (text.contains("=")) {
                String[] values = StringUtils.trimArrayElements((String[])StringUtils.split((String)text, (String)"="));
                location = values[1];
                path = values[0];
            }
            this.id = this.extractId(path);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            this.setLocation(location);
            this.path = path;
        }

        public ZuulRoute(String path, String location) {
            this.id = this.extractId(path);
            this.path = path;
            this.setLocation(location);
        }

        public String getLocation() {
            if (StringUtils.hasText((String)this.url)) {
                return this.url;
            }
            return this.serviceId;
        }

        public void setLocation(String location) {
            if (location != null && (location.startsWith("http:") || location.startsWith("https:"))) {
                this.url = location;
            } else {
                this.serviceId = location;
            }
        }

        private String extractId(String path) {
            path = path.startsWith("/") ? path.substring(1) : path;
            path = path.replace("/*", "").replace("*", "");
            return path;
        }

        public Route getRoute(String prefix) {
            return new Route(this.id, this.path, this.getLocation(), prefix, this.retryable, this.isCustomSensitiveHeaders() ? this.sensitiveHeaders : null, this.stripPrefix);
        }

        public void setSensitiveHeaders(Set<String> headers) {
            this.customSensitiveHeaders = true;
            this.sensitiveHeaders = new LinkedHashSet<String>(headers);
        }

        public boolean isCustomSensitiveHeaders() {
            return this.customSensitiveHeaders;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean isStripPrefix() {
            return this.stripPrefix;
        }

        public void setStripPrefix(boolean stripPrefix) {
            this.stripPrefix = stripPrefix;
        }

        public Boolean getRetryable() {
            return this.retryable;
        }

        public void setRetryable(Boolean retryable) {
            this.retryable = retryable;
        }

        public Set<String> getSensitiveHeaders() {
            return this.sensitiveHeaders;
        }

        public void setCustomSensitiveHeaders(boolean customSensitiveHeaders) {
            this.customSensitiveHeaders = customSensitiveHeaders;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ZuulRoute that = (ZuulRoute)o;
            return this.customSensitiveHeaders == that.customSensitiveHeaders && Objects.equals(this.id, that.id) && Objects.equals(this.path, that.path) && Objects.equals(this.retryable, that.retryable) && Objects.equals(this.sensitiveHeaders, that.sensitiveHeaders) && Objects.equals(this.serviceId, that.serviceId) && this.stripPrefix == that.stripPrefix && Objects.equals(this.url, that.url);
        }

        public int hashCode() {
            return Objects.hash(this.customSensitiveHeaders, this.id, this.path, this.retryable, this.sensitiveHeaders, this.serviceId, this.stripPrefix, this.url);
        }

        public String toString() {
            return "ZuulRoute{" + "id='" + this.id + "', " + "path='" + this.path + "', " + "serviceId='" + this.serviceId + "', " + "url='" + this.url + "', " + "stripPrefix=" + this.stripPrefix + ", " + "retryable=" + this.retryable + ", " + "sensitiveHeaders=" + this.sensitiveHeaders + ", " + "customSensitiveHeaders=" + this.customSensitiveHeaders + ", " + "}";
        }
    }
}

