/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.solr.core.DefaultQueryParser;
import org.springframework.data.solr.core.QueryParser;
import org.springframework.data.solr.core.TermsQueryParser;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.HighlightQuery;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.data.solr.core.query.TermsQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class QueryParsers {
    private final QueryParser defaultQueryParser;
    private final List<QueryParserPair> parserPairs;
    private final Map<Class<?>, QueryParser> cache = new LinkedHashMap();
    @Nullable
    private final MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> mappingContext;

    public QueryParsers(@Nullable MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> mappingContext) {
        this.parserPairs = new ArrayList<QueryParserPair>(4);
        this.mappingContext = mappingContext;
        this.defaultQueryParser = new DefaultQueryParser((MappingContext)mappingContext);
        this.parserPairs.add(new QueryParserPair(TermsQuery.class, new TermsQueryParser(mappingContext)));
        this.parserPairs.add(new QueryParserPair(FacetQuery.class, this.defaultQueryParser));
        this.parserPairs.add(new QueryParserPair(HighlightQuery.class, this.defaultQueryParser));
        this.parserPairs.add(new QueryParserPair(Query.class, this.defaultQueryParser));
    }

    public QueryParser getForClass(Class<? extends SolrDataQuery> clazz) {
        QueryParser queryParser = this.cache.get(clazz);
        if (queryParser == null) {
            for (QueryParserPair pair : this.parserPairs) {
                if (!pair.canParser(clazz)) continue;
                this.cache.put(clazz, pair.getParser());
                queryParser = pair.getParser();
                break;
            }
        }
        return queryParser != null ? queryParser : this.defaultQueryParser;
    }

    public void registerParser(Class<? extends SolrDataQuery> clazz, QueryParser parser) {
        Assert.notNull((Object)parser, (String)"Cannot register 'null' parser.");
        this.parserPairs.add(0, new QueryParserPair(clazz, parser));
        this.cache.clear();
    }

    private static class QueryParserPair {
        private final Class<?> clazz;
        private final QueryParser parser;

        public QueryParserPair(Class<?> clazz, QueryParser parser) {
            this.parser = parser;
            this.clazz = clazz;
        }

        public QueryParser getParser() {
            return this.parser;
        }

        public boolean canParser(Class<?> clazz) {
            return ClassUtils.isAssignable(this.clazz, clazz);
        }
    }
}

