/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.Function;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.util.Assert;

public class IfFunction
extends AbstractFunction {
    private static final String OPERATION = "if";

    private IfFunction() {
    }

    public static Builder when(Object condition) {
        return new Builder(condition);
    }

    public static Builder when(Field field) {
        Assert.notNull((Object)field, (String)"Field cannot be 'null' in if clause.");
        return new Builder(field);
    }

    public static Builder when(String fieldname) {
        Assert.hasText((String)fieldname, (String)"Fieldname cannot be 'null' for if clause.");
        return IfFunction.when(new SimpleField(fieldname));
    }

    public static Builder when(Function function) {
        Assert.notNull((Object)function, (String)"Function cannot be 'null' for if clause.");
        return new Builder(function);
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }

    public static class Builder {
        private IfFunction function;

        public Builder(Object condition) {
            Assert.notNull((Object)condition, (String)"Condition cannot be 'null' for if operation");
            this.function = new IfFunction();
            this.function.addArgument(condition);
        }

        public Builder then(Object value) {
            Assert.notNull((Object)value, (String)"True value cannot be 'null' for if operation.");
            this.function.addArgument(value);
            return this;
        }

        public IfFunction otherwise(Object value) {
            Assert.notNull((Object)value, (String)"False value cannot be 'null' for if operation.");
            this.function.addArgument(value);
            return this.function;
        }
    }
}

