/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Join {
    @Nullable
    private Field from;
    @Nullable
    private Field to;
    @Nullable
    private String fromIndex;

    private Join() {
    }

    public Join(Field from, Field to) {
        this(from, to, null);
    }

    public Join(Field from, Field to, @Nullable String fromIndex) {
        this.from = from;
        this.to = to;
        this.fromIndex = fromIndex;
    }

    public static Builder from(Field from) {
        return new Builder(from);
    }

    public static Builder from(String fieldname) {
        return Join.from(new SimpleField(fieldname));
    }

    @Nullable
    public Field getFrom() {
        return this.from;
    }

    @Nullable
    public Field getTo() {
        return this.to;
    }

    @Nullable
    public String getFromIndex() {
        return this.fromIndex;
    }

    public static class Builder {
        private Join join;

        public Builder(Field from) {
            Assert.notNull((Object)from, (String)"From must not be null!");
            this.join = new Join();
            this.join.from = from;
        }

        public Builder(String fieldname) {
            this(new SimpleField(fieldname));
        }

        public Join to(Field to) {
            Assert.notNull((Object)to, (String)"To must not be null!");
            this.join.to = to;
            return this.join;
        }

        public Join to(String fieldname) {
            return this.to(new SimpleField(fieldname));
        }

        public Builder fromIndex(String fromIndex) {
            this.join.fromIndex = fromIndex;
            return this;
        }
    }
}

