/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Collections;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.Function;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.util.Assert;

public class NotFunction
extends AbstractFunction {
    private static final String OPERATION = "not";

    private NotFunction(Object condition) {
        super(Collections.singletonList(condition));
    }

    public static NotFunction not(Field field) {
        Assert.notNull((Object)field, (String)"Field for not function must not be 'null'");
        return new NotFunction(field);
    }

    public static NotFunction not(String fieldName) {
        Assert.notNull((Object)fieldName, (String)"FieldName must not be null!");
        return NotFunction.not(new SimpleField(fieldName));
    }

    public static NotFunction not(Function condition) {
        Assert.notNull((Object)condition, (String)"Condition for not function must not be 'null'");
        return new NotFunction(condition);
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }
}

