/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.solr.core.query.AbstractQuery;
import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.FilterQuery;
import org.springframework.data.solr.core.query.GroupOptions;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.data.solr.core.query.SimpleStringCriteria;
import org.springframework.data.solr.core.query.SolrPageRequest;
import org.springframework.data.solr.core.query.SpellcheckOptions;
import org.springframework.data.solr.core.query.StatsOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleQuery
extends AbstractQuery
implements Query,
FilterQuery {
    private List<Field> projectionOnFields = new ArrayList<Field>(0);
    private List<FilterQuery> filterQueries = new ArrayList<FilterQuery>(0);
    @Nullable
    private Long offset = null;
    @Nullable
    private Integer rows = null;
    private Sort sort = Sort.unsorted();
    @Nullable
    private Query.Operator defaultOperator;
    @Nullable
    private Integer timeAllowed;
    @Nullable
    private String defType;
    @Nullable
    private GroupOptions groupOptions;
    @Nullable
    private StatsOptions statsOptions;
    @Nullable
    private SpellcheckOptions spellcheckOptions;

    public SimpleQuery() {
    }

    public SimpleQuery(Criteria criteria) {
        this(criteria, Pageable.unpaged());
    }

    public SimpleQuery(String queryString) {
        this(new SimpleStringCriteria(queryString));
    }

    public SimpleQuery(Criteria criteria, @Nullable Pageable pageable) {
        super(criteria);
        if (pageable != null && !pageable.isUnpaged()) {
            this.offset = pageable.getOffset();
            this.rows = pageable.getPageSize();
            this.addSort(pageable.getSort());
        }
    }

    public SimpleQuery(String queryString, Pageable pageable) {
        this(new SimpleStringCriteria(queryString), pageable);
    }

    @Nullable
    public static final Query fromQuery(Query source) {
        return SimpleQuery.fromQuery(source, new SimpleQuery());
    }

    @Nullable
    public static <T extends SimpleQuery> T fromQuery(@Nullable Query source, @Nullable T destination) {
        if (source == null || destination == null) {
            return null;
        }
        if (source.getCriteria() != null) {
            destination.addCriteria(source.getCriteria());
        }
        if (!source.getFilterQueries().isEmpty()) {
            for (FilterQuery fq : source.getFilterQueries()) {
                destination.addFilterQuery(fq);
            }
        }
        if (!source.getProjectionOnFields().isEmpty()) {
            for (Field projectionField : source.getProjectionOnFields()) {
                destination.addProjectionOnField(projectionField);
            }
        }
        if (!source.getGroupByFields().isEmpty()) {
            for (Field groupByField : source.getGroupByFields()) {
                destination.addGroupByField(groupByField);
            }
        }
        if (source.getSort() != null) {
            destination.addSort(source.getSort());
        }
        if (source.getDefType() != null) {
            destination.setDefType(source.getDefType());
        }
        if (source.getDefaultOperator() != null) {
            destination.setDefaultOperator(source.getDefaultOperator());
        }
        if (source.getTimeAllowed() != null) {
            destination.setTimeAllowed(source.getTimeAllowed());
        }
        if (source.getRequestHandler() != null) {
            destination.setRequestHandler(source.getRequestHandler());
        }
        return destination;
    }

    @Override
    public final <T extends Query> T addProjectionOnField(Field field) {
        Assert.notNull((Object)field, (String)"Field for projection must not be null.");
        Assert.hasText((String)field.getName(), (String)"Field.name for projection must not be null/empty.");
        this.projectionOnFields.add(field);
        return (T)this;
    }

    public final <T extends Query> T addProjectionOnField(String fieldname) {
        return this.addProjectionOnField(new SimpleField(fieldname));
    }

    public final <T extends Query> T addProjectionOnFields(Field ... fields) {
        Assert.notEmpty((Object[])fields, (String)"Cannot add projection on null/empty field list.");
        for (Field field : fields) {
            this.addProjectionOnField(field);
        }
        return (T)this;
    }

    public final <T extends Query> T addProjectionOnFields(String ... fieldnames) {
        Assert.notEmpty((Object[])fieldnames, (String)"Cannot add projection on null/empty field list.");
        for (String fieldname : fieldnames) {
            this.addProjectionOnField(fieldname);
        }
        return (T)this;
    }

    @Override
    public final <T extends Query> T setPageRequest(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        this.offset = pageable.getOffset();
        this.rows = pageable.getPageSize();
        return this.addSort(pageable.getSort());
    }

    @Override
    public <T extends Query> T setOffset(Long offset) {
        this.offset = offset;
        return (T)this;
    }

    @Override
    public <T extends Query> T setRows(Integer rows) {
        this.rows = rows;
        return (T)this;
    }

    @Override
    @Deprecated
    public final <T extends Query> T addGroupByField(Field field) {
        Assert.notNull((Object)field, (String)"Field for grouping must not be null.");
        Assert.hasText((String)field.getName(), (String)"Field.name for grouping must not be null/empty.");
        if (this.groupOptions == null) {
            this.groupOptions = new GroupOptions();
        }
        this.groupOptions.addGroupByField(field).setGroupMain(true);
        return (T)this;
    }

    @Deprecated
    public final <T extends Query> T addGroupByField(String fieldname) {
        return this.addGroupByField(new SimpleField(fieldname));
    }

    @Override
    public final <T extends Query> T addSort(@Nullable Sort sort) {
        if (sort == null) {
            return (T)this;
        }
        this.sort = this.sort == null ? sort : this.sort.and(sort);
        return (T)this;
    }

    @Override
    public Sort getSort() {
        return this.sort;
    }

    @Override
    public Pageable getPageRequest() {
        if (this.rows == null && this.offset == null) {
            return Pageable.unpaged();
        }
        int rows = this.rows != null ? this.rows : 10;
        long offset = this.offset != null ? this.offset : 0L;
        return new SolrPageRequest(rows != 0 ? (int)(offset / (long)rows) : 0, rows, this.sort);
    }

    @Override
    @Nullable
    public Long getOffset() {
        return this.offset;
    }

    @Override
    @Nullable
    public Integer getRows() {
        return this.rows;
    }

    @Override
    @Deprecated
    public List<Field> getGroupByFields() {
        if (this.groupOptions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.groupOptions.getGroupByFields());
    }

    @Override
    public List<Field> getProjectionOnFields() {
        return Collections.unmodifiableList(this.projectionOnFields);
    }

    @Override
    public <T extends Query> T addFilterQuery(FilterQuery filterQuery) {
        this.filterQueries.add(filterQuery);
        return (T)this;
    }

    @Override
    public <T extends Query> T setTimeAllowed(Integer timeAllowed) {
        this.timeAllowed = timeAllowed;
        return (T)this;
    }

    @Override
    @Nullable
    public Integer getTimeAllowed() {
        return this.timeAllowed;
    }

    @Override
    public <T extends Query> T setGroupOptions(GroupOptions groupOptions) {
        this.groupOptions = groupOptions;
        return (T)this;
    }

    @Override
    @Nullable
    public GroupOptions getGroupOptions() {
        return this.groupOptions;
    }

    @Override
    @Nullable
    public StatsOptions getStatsOptions() {
        return this.statsOptions;
    }

    @Override
    public <T extends Query> T setStatsOptions(StatsOptions statsOptions) {
        this.statsOptions = statsOptions;
        return (T)this;
    }

    @Override
    public List<FilterQuery> getFilterQueries() {
        return Collections.unmodifiableList(this.filterQueries);
    }

    @Override
    public Query.Operator getDefaultOperator() {
        return this.defaultOperator != null ? this.defaultOperator : Query.Operator.NONE;
    }

    public boolean hasDefaultOperatorDefined() {
        return !Query.Operator.NONE.equals((Object)this.getDefaultOperator());
    }

    @Override
    public void setDefaultOperator(Query.Operator operator) {
        this.defaultOperator = operator;
    }

    @Override
    public String getDefType() {
        return this.defType != null ? this.defType : "";
    }

    @Override
    public void setDefType(String defType) {
        this.defType = defType;
    }

    @Override
    public <T extends Query> T setSpellcheckOptions(SpellcheckOptions spellcheckOptions) {
        this.spellcheckOptions = spellcheckOptions;
        return (T)this;
    }

    @Override
    @Nullable
    public SpellcheckOptions getSpellcheckOptions() {
        return this.spellcheckOptions;
    }
}

