/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SpellcheckOptions;
import org.springframework.data.solr.repository.Facet;
import org.springframework.data.solr.repository.Highlight;
import org.springframework.data.solr.repository.Pivot;
import org.springframework.data.solr.repository.Query;
import org.springframework.data.solr.repository.SelectiveStats;
import org.springframework.data.solr.repository.Spellcheck;
import org.springframework.data.solr.repository.Stats;
import org.springframework.data.solr.repository.query.SolrEntityInformationCreator;
import org.springframework.data.solr.repository.query.SolrParameters;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SolrQueryMethod
extends QueryMethod {
    private final Method method;

    public SolrQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, SolrEntityInformationCreator solrInformationCreator) {
        super(method, metadata, factory);
        this.method = method;
    }

    public boolean hasAnnotatedQuery() {
        return this.getAnnotatedQuery() != null;
    }

    public boolean hasQueryAnnotation() {
        return this.method.getAnnotation(Query.class) != null;
    }

    @Nullable
    String getAnnotatedQuery() {
        return this.getAnnotationValueAsStringOrNullIfBlank(this.getQueryAnnotation(), "value");
    }

    public boolean hasAnnotatedNamedQueryName() {
        return this.getAnnotatedNamedQueryName() != null;
    }

    @Nullable
    String getAnnotatedNamedQueryName() {
        return this.getAnnotationValueAsStringOrNullIfBlank(this.getQueryAnnotation(), "name");
    }

    private Query getQueryAnnotation() {
        return this.method.getAnnotation(Query.class);
    }

    TypeInformation<?> getReturnType() {
        return ClassTypeInformation.fromReturnTypeOf((Method)this.method);
    }

    public boolean hasProjectionFields() {
        return this.hasQueryAnnotation() && !CollectionUtils.isEmpty(this.getProjectionFields());
    }

    public List<String> getProjectionFields() {
        return this.getAnnotationValuesAsStringList(this.getQueryAnnotation(), "fields");
    }

    @Nullable
    public Integer getTimeAllowed() {
        if (this.hasQueryAnnotation()) {
            return this.getAnnotationValueAsIntOrNullIfNegative(this.getQueryAnnotation(), "timeAllowed");
        }
        return null;
    }

    public boolean isFacetQuery() {
        return this.hasFacetFields() || this.hasFacetQueries() || this.hasPivotFields();
    }

    public boolean hasFacetFields() {
        return this.hasFacetAnnotation() && !CollectionUtils.isEmpty(this.getFacetFields());
    }

    public boolean hasPivotFields() {
        return this.hasFacetAnnotation() && !CollectionUtils.isEmpty(this.getPivotFields());
    }

    private boolean hasFacetAnnotation() {
        return this.getFacetAnnotation() != null;
    }

    public List<String> getFacetFields() {
        return this.getAnnotationValuesAsStringList(this.getFacetAnnotation(), "fields");
    }

    public List<String> getFacetQueries() {
        return this.getAnnotationValuesAsStringList(this.getFacetAnnotation(), "queries");
    }

    public List<String[]> getPivotFields() {
        List<Pivot> pivotFields = this.getAnnotationValuesList(this.getFacetAnnotation(), "pivots", Pivot.class);
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (Pivot pivot : pivotFields) {
            result.add(pivot.value());
        }
        return result;
    }

    public boolean hasFacetQueries() {
        return this.hasFacetAnnotation() && !CollectionUtils.isEmpty(this.getFacetQueries());
    }

    @Nullable
    private Facet getFacetAnnotation() {
        return this.method.getAnnotation(Facet.class);
    }

    @Nullable
    public Integer getFacetLimit() {
        Facet facetAnnotation = this.getFacetAnnotation();
        if (facetAnnotation != null) {
            return (Integer)AnnotationUtils.getValue((Annotation)this.getFacetAnnotation(), (String)"limit");
        }
        return null;
    }

    @Nullable
    public Integer getFacetMinCount() {
        Facet facetAnnotation = this.getFacetAnnotation();
        if (facetAnnotation != null) {
            return (Integer)AnnotationUtils.getValue((Annotation)this.getFacetAnnotation(), (String)"minCount");
        }
        return null;
    }

    @Nullable
    public String getFacetPrefix() {
        return this.getAnnotationValueAsStringOrNullIfBlank(this.getFacetAnnotation(), "prefix");
    }

    @Nullable
    private Stats getStatsAnnotation() {
        return this.method.getAnnotation(Stats.class);
    }

    public boolean hasStatsDefinition() {
        return this.getStatsAnnotation() != null && (!this.getFieldStats().isEmpty() || !this.getStatsFacets().isEmpty() || !this.getStatsSelectiveFacets().isEmpty() || !this.getStatsSelectiveCountDistinctFields().isEmpty());
    }

    public boolean isFieldStatsCountDistinctEnable() {
        Stats stats = this.getStatsAnnotation();
        return stats != null && stats.distinct();
    }

    public List<String> getFieldStats() {
        return this.getAnnotationValuesAsStringList(this.getStatsAnnotation(), "value");
    }

    public List<String> getStatsFacets() {
        return this.getAnnotationValuesAsStringList(this.getStatsAnnotation(), "facets");
    }

    public Map<String, String[]> getStatsSelectiveFacets() {
        List<SelectiveStats> selective = this.getAnnotationValuesList(this.getStatsAnnotation(), "selective", SelectiveStats.class);
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
        for (SelectiveStats selectiveFacet : selective) {
            result.put(selectiveFacet.field(), selectiveFacet.facets());
        }
        return result;
    }

    public Collection<String> getStatsSelectiveCountDistinctFields() {
        List<SelectiveStats> selective = this.getAnnotationValuesList(this.getStatsAnnotation(), "selective", SelectiveStats.class);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (SelectiveStats selectiveFacet : selective) {
            if (!selectiveFacet.distinct()) continue;
            result.add(selectiveFacet.field());
        }
        return result;
    }

    public boolean hasFilterQuery() {
        return this.hasQueryAnnotation() && !CollectionUtils.isEmpty(this.getFilterQueries());
    }

    public boolean isDeleteQuery() {
        return this.hasQueryAnnotation() && (Boolean)AnnotationUtils.getValue((Annotation)this.getQueryAnnotation(), (String)"delete") != false;
    }

    @Nullable
    private Annotation getHighlightAnnotation() {
        return this.method.getAnnotation(Highlight.class);
    }

    private boolean hasHighlightAnnotation() {
        return this.getHighlightAnnotation() != null;
    }

    public boolean isHighlightQuery() {
        return this.hasHighlightAnnotation();
    }

    public List<String> getHighlightFieldNames() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValuesAsStringList(this.getHighlightAnnotation(), "fields");
        }
        return Collections.emptyList();
    }

    @Nullable
    public String getHighlightQuery() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsStringOrNullIfBlank(this.getHighlightAnnotation(), "query");
        }
        return null;
    }

    @Nullable
    public Integer getHighlighSnipplets() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsIntOrNullIfNegative(this.getHighlightAnnotation(), "snipplets");
        }
        return null;
    }

    @Nullable
    public Integer getHighlightFragsize() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsIntOrNullIfNegative(this.getHighlightAnnotation(), "fragsize");
        }
        return null;
    }

    @Nullable
    public String getHighlightFormatter() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsStringOrNullIfBlank(this.getHighlightAnnotation(), "formatter");
        }
        return null;
    }

    @Nullable
    public String getHighlightPrefix() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsStringOrNullIfBlank(this.getHighlightAnnotation(), "prefix");
        }
        return null;
    }

    @Nullable
    public String getHighlightPostfix() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsStringOrNullIfBlank(this.getHighlightAnnotation(), "postfix");
        }
        return null;
    }

    public boolean hasHighlightFields() {
        return !this.getHighlightFieldNames().isEmpty();
    }

    List<String> getFilterQueries() {
        return this.getAnnotationValuesAsStringList(this.getQueryAnnotation(), "filters");
    }

    public Query.Operator getDefaultOperator() {
        if (this.hasQueryAnnotation()) {
            return this.getQueryAnnotation().defaultOperator();
        }
        return Query.Operator.NONE;
    }

    @Nullable
    public String getDefType() {
        if (this.hasQueryAnnotation()) {
            return this.getQueryAnnotation().defType();
        }
        return null;
    }

    @Nullable
    public String getRequestHandler() {
        if (this.hasQueryAnnotation()) {
            return this.getQueryAnnotation().requestHandler();
        }
        return null;
    }

    @Nullable
    public Spellcheck getSpellcheckAnnotation() {
        return (Spellcheck)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, Spellcheck.class);
    }

    public boolean hasSpellcheck() {
        return this.getSpellcheckAnnotation() != null;
    }

    @Nullable
    public SpellcheckOptions getSpellcheckOptions() {
        Spellcheck spellcheck = this.getSpellcheckAnnotation();
        if (spellcheck == null) {
            return null;
        }
        SpellcheckOptions sc = SpellcheckOptions.spellcheck();
        if (spellcheck.accuracy() >= 0.0f) {
            sc = sc.accuracy(spellcheck.accuracy());
        }
        if (spellcheck.buildDictionary()) {
            sc = sc.buildDictionary();
        }
        if (spellcheck.collate()) {
            sc = sc.collate();
        }
        if (spellcheck.collateExtendedResults()) {
            sc = sc.collateExtendedResults();
        }
        if (spellcheck.onlyMorePopular()) {
            sc = sc.onlyMorePopular();
        }
        if (spellcheck.alternativeTermCount() >= 0L) {
            sc = sc.alternativeTermCount(spellcheck.alternativeTermCount());
        }
        if (spellcheck.count() >= 0L) {
            sc = sc.count(spellcheck.count());
        }
        if (!ObjectUtils.isEmpty((Object[])spellcheck.dictionaries())) {
            sc = sc.dictionaries(spellcheck.dictionaries());
        }
        if (spellcheck.maxCollationEvaluations() >= 0L) {
            sc = sc.maxCollationEvaluations(spellcheck.maxCollationEvaluations());
        }
        if (spellcheck.maxCollations() >= 0L) {
            sc = sc.maxCollations(spellcheck.maxCollations());
        }
        if (spellcheck.maxCollationsTries() >= 0L) {
            sc = sc.maxCollationTries(spellcheck.maxCollationsTries());
        }
        if (spellcheck.maxResultsForSuggest() >= 0L) {
            sc = sc.maxResultsForSuggest(spellcheck.maxResultsForSuggest());
        }
        if (spellcheck.maxCollationCollectDocs() >= 0L) {
            sc = sc.maxCollationCollectDocs(spellcheck.maxCollationCollectDocs());
        }
        if (spellcheck.extendedResults()) {
            sc = sc.extendedResults();
        }
        return sc;
    }

    private String getAnnotationValueAsStringOrNullIfBlank(@Nullable Annotation annotation, String attributeName) {
        if (annotation == null) {
            return null;
        }
        String value = (String)AnnotationUtils.getValue((Annotation)annotation, (String)attributeName);
        return StringUtils.hasText((String)value) ? value : null;
    }

    @Nullable
    private Integer getAnnotationValueAsIntOrNullIfNegative(@Nullable Annotation annotation, String attributeName) {
        if (annotation == null) {
            return null;
        }
        Integer timeAllowed = (Integer)AnnotationUtils.getValue((Annotation)annotation, (String)attributeName);
        if (timeAllowed != null && timeAllowed > 0) {
            return timeAllowed;
        }
        return null;
    }

    private List<String> getAnnotationValuesAsStringList(@Nullable Annotation annotation, String attribute) {
        if (annotation == null) {
            return Collections.emptyList();
        }
        String[] values = (String[])AnnotationUtils.getValue((Annotation)annotation, (String)attribute);
        if (values.length > 1 || values.length == 1 && StringUtils.hasText((String)values[0])) {
            return CollectionUtils.arrayToList((Object)values);
        }
        return Collections.emptyList();
    }

    private <T> List<T> getAnnotationValuesList(@Nullable Annotation annotation, String attribute, Class<T> clazz) {
        if (annotation == null) {
            return Collections.emptyList();
        }
        Object[] values = (Object[])AnnotationUtils.getValue((Annotation)annotation, (String)attribute);
        return CollectionUtils.arrayToList((Object)values);
    }

    public String getNamedQueryName() {
        if (!this.hasAnnotatedNamedQueryName()) {
            return super.getNamedQueryName();
        }
        return this.getAnnotatedNamedQueryName();
    }

    public boolean returnsOptional() {
        return ClassUtils.isAssignable(Optional.class, (Class)this.getReturnedObjectType());
    }

    protected SolrParameters createParameters(Method method) {
        return new SolrParameters(method);
    }

    public SolrParameters getParameters() {
        return (SolrParameters)super.getParameters();
    }
}

