/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink.support;

import java.lang.reflect.Method;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.logging.SessionLogEntry;
import oracle.toplink.publicinterface.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ReflectionUtils;

public class CommonsLoggingSessionLog
extends AbstractSessionLog {
    public static final String NAMESPACE_PREFIX = "oracle.toplink.";
    public static final String DEFAULT_NAMESPACE = "session";
    public static final String DEFAULT_SEPARATOR = "--";
    private static Method getSessionMethod;
    private static Method getExceptionMethod;
    private String separator = "--";

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void log(SessionLogEntry entry) {
        Log logger = LogFactory.getLog((String)this.getCategory(entry));
        switch (entry.getLevel()) {
            case 7: {
                if (!logger.isErrorEnabled()) break;
                if (entry.hasException()) {
                    logger.error((Object)this.getMessageString(entry), this.getException(entry));
                    break;
                }
                logger.error((Object)this.getMessageString(entry));
                break;
            }
            case 6: {
                if (!logger.isWarnEnabled()) break;
                if (entry.hasException()) {
                    logger.warn((Object)this.getMessageString(entry), this.getException(entry));
                    break;
                }
                logger.warn((Object)this.getMessageString(entry));
                break;
            }
            case 5: {
                if (!logger.isInfoEnabled()) break;
                if (entry.hasException()) {
                    logger.info((Object)this.getMessageString(entry), this.getException(entry));
                    break;
                }
                logger.info((Object)this.getMessageString(entry));
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (!logger.isDebugEnabled()) break;
                if (entry.hasException()) {
                    logger.debug((Object)this.getMessageString(entry), this.getException(entry));
                    break;
                }
                logger.debug((Object)this.getMessageString(entry));
                break;
            }
            case 1: {
                if (!logger.isTraceEnabled()) break;
                if (entry.hasException()) {
                    logger.trace((Object)this.getMessageString(entry), this.getException(entry));
                    break;
                }
                logger.trace((Object)this.getMessageString(entry));
            }
        }
    }

    protected String getCategory(SessionLogEntry entry) {
        String namespace = entry.getNameSpace();
        return NAMESPACE_PREFIX + (namespace != null ? namespace : DEFAULT_NAMESPACE);
    }

    protected String getMessageString(SessionLogEntry entry) {
        Accessor connection;
        StringBuffer buf = new StringBuffer();
        Session session = this.getSession(entry);
        if (session != null) {
            buf.append(this.getSessionString((oracle.toplink.sessions.Session)session));
            buf.append(this.getSeparator());
        }
        if ((connection = entry.getConnection()) != null) {
            buf.append(this.getConnectionString(connection));
            buf.append(this.getSeparator());
        }
        buf.append(this.formatMessage(entry));
        return buf.toString();
    }

    protected Session getSession(SessionLogEntry entry) {
        return (Session)ReflectionUtils.invokeMethod((Method)getSessionMethod, (Object)entry);
    }

    protected Throwable getException(SessionLogEntry entry) {
        return (Throwable)ReflectionUtils.invokeMethod((Method)getExceptionMethod, (Object)entry);
    }

    static {
        try {
            getSessionMethod = SessionLogEntry.class.getMethod("getSession", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Could not find method SessionLogEntry.getSession()");
        }
        try {
            getExceptionMethod = SessionLogEntry.class.getMethod("getException", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Could not find method SessionLogEntry.getException()");
        }
    }
}

