/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.Generated;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.json.JsonMediaType;

final class PrimitiveJsonPropertyBodyFilter
implements BodyFilter {
    private static final String BOOLEAN_PATTERN = "(?>true|false)";
    private static final String NUMBER_PATTERN = "(?>-?(?>0|[1-9][0-9]*)(?>\\.[0-9]+)?(?>[eE][+-]?[0-9]+)?)";
    private static final Pattern NUMBER = PrimitiveJsonPropertyBodyFilter.pattern("(?>-?(?>0|[1-9][0-9]*)(?>\\.[0-9]+)?(?>[eE][+-]?[0-9]+)?)");
    private static final String STRING_VALUE_PATTERN = "(?>\\\\(?>[\"\\\\/bfnrt]|u[a-fA-F0-9]{4})|[^\"\\\\\u0000-\\x1F\\x7F]+)*";
    private static final String STRING_PATTERN = "(?>\"(?>\\\\(?>[\"\\\\/bfnrt]|u[a-fA-F0-9]{4})|[^\"\\\\\u0000-\\x1F\\x7F]+)*\")";
    private static final Pattern STRING = PrimitiveJsonPropertyBodyFilter.pattern("(?>\"(?>\\\\(?>[\"\\\\/bfnrt]|u[a-fA-F0-9]{4})|[^\"\\\\\u0000-\\x1F\\x7F]+)*\")");
    private static final String PRIMITIVE_PATTERN = "(?>(?>true|false)|(?>-?(?>0|[1-9][0-9]*)(?>\\.[0-9]+)?(?>[eE][+-]?[0-9]+)?)|(?>\"(?>\\\\(?>[\"\\\\/bfnrt]|u[a-fA-F0-9]{4})|[^\"\\\\\u0000-\\x1F\\x7F]+)*\"))";
    private static final Pattern PRIMITIVE = PrimitiveJsonPropertyBodyFilter.pattern("(?>(?>true|false)|(?>-?(?>0|[1-9][0-9]*)(?>\\.[0-9]+)?(?>[eE][+-]?[0-9]+)?)|(?>\"(?>\\\\(?>[\"\\\\/bfnrt]|u[a-fA-F0-9]{4})|[^\"\\\\\u0000-\\x1F\\x7F]+)*\"))");
    private final Pattern pattern;
    private final Predicate<String> predicate;
    private final String replacement;

    private static Pattern pattern(String value) {
        return Pattern.compile("(?<key>\"(?<property>(?>\\\\(?>[\"\\\\/bfnrt]|u[a-fA-F0-9]{4})|[^\"\\\\\u0000-\\x1F\\x7F]+)*)\"\\s*:\\s*)(" + value + "|null)");
    }

    static BodyFilter replaceString(Predicate<String> predicate, String replacement) {
        return PrimitiveJsonPropertyBodyFilter.create(STRING, predicate, PrimitiveJsonPropertyBodyFilter.quote(replacement));
    }

    static BodyFilter replaceNumber(Predicate<String> predicate, Number replacement) {
        return PrimitiveJsonPropertyBodyFilter.create(NUMBER, predicate, String.valueOf(replacement));
    }

    static BodyFilter replacePrimitive(Predicate<String> predicate, String replacement) {
        return PrimitiveJsonPropertyBodyFilter.create(PRIMITIVE, predicate, PrimitiveJsonPropertyBodyFilter.quote(replacement));
    }

    public static String quote(String s) {
        return "\"" + s + "\"";
    }

    public String filter(@Nullable String contentType, String body) {
        if (JsonMediaType.JSON.test(contentType)) {
            Matcher matcher = this.pattern.matcher(body);
            StringBuffer result = new StringBuffer(body.length());
            while (matcher.find()) {
                if (this.predicate.test(matcher.group("property"))) {
                    matcher.appendReplacement(result, "${key}");
                    result.append(this.replacement);
                    continue;
                }
                matcher.appendReplacement(result, "$0");
            }
            matcher.appendTail(result);
            return result.toString();
        }
        return body;
    }

    public BodyFilter tryMerge(BodyFilter next) {
        PrimitiveJsonPropertyBodyFilter filter;
        if (next instanceof PrimitiveJsonPropertyBodyFilter && this.compatibleWith(filter = (PrimitiveJsonPropertyBodyFilter)next)) {
            return this.withPredicate(this.predicate.or(filter.predicate));
        }
        return null;
    }

    public boolean compatibleWith(PrimitiveJsonPropertyBodyFilter that) {
        return this.pattern.equals(that.pattern) && this.replacement.equals(that.replacement);
    }

    @Generated
    private PrimitiveJsonPropertyBodyFilter(Pattern pattern, Predicate<String> predicate, String replacement) {
        this.pattern = pattern;
        this.predicate = predicate;
        this.replacement = replacement;
    }

    @Generated
    private static PrimitiveJsonPropertyBodyFilter create(Pattern pattern, Predicate<String> predicate, String replacement) {
        return new PrimitiveJsonPropertyBodyFilter(pattern, predicate, replacement);
    }

    @Generated
    private PrimitiveJsonPropertyBodyFilter withPredicate(Predicate<String> predicate) {
        return this.predicate == predicate ? this : new PrimitiveJsonPropertyBodyFilter(this.pattern, predicate, this.replacement);
    }
}

