/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.Log;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.EventLoopGroup;
import software.amazon.awssdk.crt.io.HostResolver;

public abstract class CrtResource
implements AutoCloseable {
    private static final String NATIVE_DEBUG_PROPERTY_NAME = "aws.crt.debugnative";
    private static final int DEBUG_CLEANUP_WAIT_TIME_IN_SECONDS = 60;
    private static final long NULL = 0L;
    private static final Log.LogLevel ResourceLogLevel = Log.LogLevel.Debug;
    private static final HashMap<Long, ResourceInstance> CRT_RESOURCES = new HashMap();
    private static boolean debugNativeObjects = System.getProperty("aws.crt.debugnative") != null;
    private static int resourceCount = 0;
    private static final Lock lock = new ReentrantLock();
    private static final Condition emptyResources = lock.newCondition();
    private static final AtomicLong nextId = new AtomicLong(0L);
    private final ArrayList<CrtResource> referencedResources = new ArrayList();
    private long nativeHandle;
    private AtomicInteger refCount = new AtomicInteger(1);
    private long id = nextId.getAndAdd(1L);
    private Instant creationTime = Instant.now();
    private String description;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CrtResource() {
        if (!debugNativeObjects) return;
        String canonicalName = this.getClass().getCanonicalName();
        Class<CrtResource> clazz = CrtResource.class;
        synchronized (CrtResource.class) {
            CRT_RESOURCES.put(this.id, new ResourceInstance(this, canonicalName));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Log.log(ResourceLogLevel, Log.LogSubject.JavaCrtResource, String.format("CrtResource of class %s(%d) created", this.getClass().getCanonicalName(), this.id));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReferenceTo(CrtResource resource) {
        if (debugNativeObjects) {
            Log.log(ResourceLogLevel, Log.LogSubject.JavaCrtResource, String.format("%s(%d) is adding a reference to %s(%d)", this.getClass().getCanonicalName(), this.id, resource.getClass().getCanonicalName(), resource.id));
        }
        resource.addRef();
        CrtResource crtResource = this;
        synchronized (crtResource) {
            this.referencedResources.add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReferenceTo(CrtResource resource) {
        boolean removed = false;
        CrtResource crtResource = this;
        synchronized (crtResource) {
            removed = this.referencedResources.remove(resource);
        }
        if (debugNativeObjects) {
            if (removed) {
                Log.log(ResourceLogLevel, Log.LogSubject.JavaCrtResource, String.format("%s(%d) is removing a reference to %s(%d)", this.getClass().getCanonicalName(), this.id, resource.getClass().getCanonicalName(), resource.id));
            } else {
                Log.log(ResourceLogLevel, Log.LogSubject.JavaCrtResource, String.format("%s(%d) erroneously tried to remove a reference to %s(%d) that it was not referencing", this.getClass().getCanonicalName(), this.id, resource.getClass().getCanonicalName(), resource.id));
            }
        }
        if (!removed) {
            return;
        }
        resource.decRef(this);
    }

    protected void swapReferenceTo(CrtResource oldReference, CrtResource newReference) {
        if (oldReference != newReference) {
            if (newReference != null) {
                this.addReferenceTo(newReference);
            }
            if (oldReference != null) {
                this.removeReferenceTo(oldReference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void acquireNativeHandle(long handle) {
        if (!this.isNull()) {
            throw new IllegalStateException("Can't acquire >1 Native Pointer");
        }
        String canonicalName = this.getClass().getCanonicalName();
        if (handle == 0L) {
            throw new IllegalStateException("Can't acquire NULL Pointer: " + canonicalName);
        }
        if (debugNativeObjects) {
            Class<CrtResource> clazz = CrtResource.class;
            // MONITORENTER : software.amazon.awssdk.crt.CrtResource.class
            ResourceInstance instance = CRT_RESOURCES.get(this.id);
            if (instance != null) {
                instance.setNativeHandle(handle);
            }
            // MONITOREXIT : clazz
            Log.log(ResourceLogLevel, Log.LogSubject.JavaCrtResource, String.format("acquireNativeHandle - %s(%d) acquired native pointer %d", canonicalName, this.id, handle));
        }
        this.nativeHandle = handle;
        CrtResource.incrementNativeObjectCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void release() {
        if (debugNativeObjects) {
            Log.log(ResourceLogLevel, Log.LogSubject.JavaCrtResource, String.format("Releasing class %s(%d)", this.getClass().getCanonicalName(), this.id));
            Class<CrtResource> clazz = CrtResource.class;
            // MONITORENTER : software.amazon.awssdk.crt.CrtResource.class
            CRT_RESOURCES.remove(this.id);
            // MONITOREXIT : clazz
        }
        this.releaseNativeHandle();
        if (this.nativeHandle == 0L) return;
        CrtResource.decrementNativeObjectCount();
        this.nativeHandle = 0L;
    }

    public long getNativeHandle() {
        return this.nativeHandle;
    }

    public void addRef() {
        int updatedRefs = this.refCount.incrementAndGet();
        if (debugNativeObjects) {
            Log.log(ResourceLogLevel, Log.LogSubject.JavaCrtResource, String.format("%s(%d) is adding a reference. refCount is now %d", this.getClass().getCanonicalName(), this.id, updatedRefs));
        }
    }

    public void addRef(String desc) {
        int updatedRefs = this.refCount.incrementAndGet();
        if (debugNativeObjects) {
            Log.log(ResourceLogLevel, Log.LogSubject.JavaCrtResource, String.format("%s(%d) is adding a reference for: (%s). RefCount is now %d", this.getClass().getCanonicalName(), this.id, desc, updatedRefs));
        }
    }

    protected abstract void releaseNativeHandle();

    protected abstract boolean canReleaseReferencesImmediately();

    public boolean isNull() {
        return this.nativeHandle == 0L;
    }

    @Override
    public void close() {
        this.decRef("close() called");
    }

    public void close(String desc) {
        this.decRef(desc);
    }

    public void decRef(CrtResource decRefInstigator) {
        int remainingRefs = this.refCount.decrementAndGet();
        if (debugNativeObjects) {
            Log.log(ResourceLogLevel, Log.LogSubject.JavaCrtResource, String.format("DecRef of %s(%d) called by %s(%d). %d remaining refs", this.getClass().getCanonicalName(), this.id, decRefInstigator.getClass().getCanonicalName(), decRefInstigator.id, remainingRefs));
        }
        if (remainingRefs != 0) {
            return;
        }
        this.release();
        if (this.canReleaseReferencesImmediately()) {
            this.releaseReferences();
        }
    }

    public void decRef(String desc) {
        int remainingRefs = this.refCount.decrementAndGet();
        if (debugNativeObjects) {
            if (desc != null) {
                Log.log(ResourceLogLevel, Log.LogSubject.JavaCrtResource, String.format("DecRef on %s(%d) for: (%s). %d remaining refs", this.getClass().getCanonicalName(), this.id, desc, remainingRefs));
            } else {
                Log.log(ResourceLogLevel, Log.LogSubject.JavaCrtResource, String.format("Defref on %s(%d). %d remaining refs", this.getClass().getCanonicalName(), this.id, remainingRefs));
            }
        }
        if (remainingRefs != 0) {
            return;
        }
        this.release();
        if (this.canReleaseReferencesImmediately()) {
            this.releaseReferences();
        }
    }

    public void decRef() {
        this.decRef((String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseReferences() {
        if (debugNativeObjects) {
            Log.log(ResourceLogLevel, Log.LogSubject.JavaCrtResource, String.format("%s(%d) closing all referenced objects", this.getClass().getCanonicalName(), this.id));
        }
        CrtResource crtResource = this;
        synchronized (crtResource) {
            for (CrtResource resource : this.referencedResources) {
                resource.decRef(this);
            }
            this.referencedResources.clear();
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceLogDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("[Id %d, Class %s, Refs %d](%s) - %s", this.id, this.getClass().getSimpleName(), this.refCount.get(), this.creationTime.toString(), this.description != null ? this.description : "<null>"));
        CrtResource crtResource = this;
        synchronized (crtResource) {
            if (this.referencedResources.size() > 0) {
                builder.append("\n   Forward references by Id: ");
                for (CrtResource reference : this.referencedResources) {
                    builder.append(String.format("%d ", reference.id));
                }
            }
        }
        return builder.toString();
    }

    public static void collectNativeResources(Consumer<String> fn) {
        CrtResource.collectNativeResource(resource -> {
            String str = String.format(" * Address: %d: %s", resource.nativeHandle, resource.toString());
            fn.accept(str);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collectNativeResource(Consumer<ResourceInstance> fn) {
        Class<CrtResource> clazz = CrtResource.class;
        synchronized (CrtResource.class) {
            for (Map.Entry<Long, ResourceInstance> entry : CRT_RESOURCES.entrySet()) {
                fn.accept(entry.getValue());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void logNativeResources() {
        CrtResource.logNativeResources(ResourceLogLevel);
    }

    public static void logNativeResources(Log.LogLevel logLevel) {
        Log.log(logLevel, Log.LogSubject.JavaCrtResource, "Dumping native object set:");
        CrtResource.collectNativeResource(resource -> Log.log(logLevel, Log.LogSubject.JavaCrtResource, resource.getWrapper().getResourceLogDescription()));
    }

    private static void incrementNativeObjectCount() {
        if (!debugNativeObjects) {
            return;
        }
        lock.lock();
        try {
            Log.log(ResourceLogLevel, Log.LogSubject.JavaCrtResource, String.format("incrementNativeObjectCount - count = %d", ++resourceCount));
        }
        finally {
            lock.unlock();
        }
    }

    private static void decrementNativeObjectCount() {
        if (!debugNativeObjects) {
            return;
        }
        lock.lock();
        try {
            Log.log(ResourceLogLevel, Log.LogSubject.JavaCrtResource, String.format("decrementNativeObjectCount - count = %d", --resourceCount));
            if (resourceCount == 0) {
                emptyResources.signal();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void waitForNoResources() {
        ClientBootstrap.closeStaticDefault();
        EventLoopGroup.closeStaticDefault();
        HostResolver.closeStaticDefault();
        if (debugNativeObjects) {
            lock.lock();
            try {
                long timeout = System.currentTimeMillis() + 60000L;
                while (resourceCount != 0 && System.currentTimeMillis() < timeout) {
                    emptyResources.await(1L, TimeUnit.SECONDS);
                }
                if (resourceCount != 0) {
                    Log.log(Log.LogLevel.Error, Log.LogSubject.JavaCrtResource, "waitForNoResources - timeOut");
                    CrtResource.logNativeResources(Log.LogLevel.Error);
                    throw new InterruptedException();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Timeout waiting for resource count to drop to zero");
            }
            finally {
                lock.unlock();
            }
        }
        CrtResource.waitForGlobalResourceDestruction(60);
    }

    private static native void waitForGlobalResourceDestruction(int var0);

    static {
        new CRT();
    }

    public class ResourceInstance {
        public long nativeHandle;
        public final String canonicalName;
        private Throwable instantiation;
        private CrtResource wrapper;

        public ResourceInstance(CrtResource wrapper, String name) {
            this.canonicalName = name;
            this.wrapper = wrapper;
            if (debugNativeObjects) {
                try {
                    throw new RuntimeException();
                }
                catch (RuntimeException ex) {
                    this.instantiation = ex;
                }
            }
        }

        public String location() {
            String str = "";
            if (debugNativeObjects) {
                StackTraceElement[] stack = this.instantiation.getStackTrace();
                for (int frameIdx = 2; frameIdx < stack.length; ++frameIdx) {
                    StackTraceElement frame = stack[frameIdx];
                    str = str + frame.toString() + "\n";
                }
            }
            return str;
        }

        public String toString() {
            String str = this.canonicalName + " allocated at:\n";
            str = str + this.location();
            return str;
        }

        public CrtResource getWrapper() {
            return this.wrapper;
        }

        public void setNativeHandle(long handle) {
            this.nativeHandle = handle;
        }
    }
}

