/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.eventstream;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.eventstream.ClientConnectionContinuation;
import software.amazon.awssdk.crt.eventstream.Header;
import software.amazon.awssdk.crt.eventstream.MessageType;

public abstract class ClientConnectionContinuationHandler
implements AutoCloseable {
    protected ClientConnectionContinuation continuation;
    private CompletableFuture<Void> closedFuture = new CompletableFuture();

    protected abstract void onContinuationMessage(List<Header> var1, byte[] var2, MessageType var3, int var4);

    private void onContinuationMessageShim(byte[] headersPayload, byte[] payload, int messageType, int messageFlags) {
        ArrayList<Header> headers = new ArrayList<Header>();
        ByteBuffer headersBuffer = ByteBuffer.wrap(headersPayload);
        while (headersBuffer.hasRemaining()) {
            Header header = Header.fromByteBuffer(headersBuffer);
            headers.add(header);
        }
        this.onContinuationMessage(headers, payload, MessageType.fromEnumValue(messageType), messageFlags);
    }

    protected void onContinuationClosed() {
        this.close();
    }

    void onContinuationClosedShim() {
        this.onContinuationClosed();
        this.closedFuture.complete(null);
    }

    public CompletableFuture<Void> getContinuationClosedFuture() {
        return this.closedFuture;
    }

    @Override
    public void close() {
        if (this.continuation != null) {
            this.continuation.decRef("close() called");
            this.continuation = null;
        }
    }
}

