/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.util.List;
import java.util.Optional;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonPointer;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.JsonNodeType;

public final class MissingNode
extends BaseJsonNode {
    private static final long serialVersionUID = 3L;
    private static final MissingNode instance = new MissingNode();

    protected MissingNode() {
    }

    protected Object readResolve() {
        return instance;
    }

    @Override
    public MissingNode deepCopy() {
        return this;
    }

    public static MissingNode getInstance() {
        return instance;
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.MISSING;
    }

    @Override
    public final boolean isMissingNode() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.NOT_AVAILABLE;
    }

    @Override
    protected String _valueDesc() {
        return "<missing>";
    }

    @Override
    public Optional<JsonNode> asOptional() {
        return Optional.empty();
    }

    public JsonNode require() {
        return (JsonNode)this._reportRequiredViolation("require() called on `MissingNode`", new Object[0]);
    }

    public JsonNode requireNonNull() {
        return (JsonNode)this._reportRequiredViolation("requireNonNull() called on `MissingNode`", new Object[0]);
    }

    @Override
    public JsonNode get(int index) {
        return null;
    }

    @Override
    public JsonNode path(String fieldName) {
        return this;
    }

    @Override
    public JsonNode path(int index) {
        return this;
    }

    @Override
    protected JsonNode _at(JsonPointer ptr) {
        return this;
    }

    @Override
    public JsonNode findValue(String fieldName) {
        return null;
    }

    @Override
    public JsonNode findParent(String fieldName) {
        return null;
    }

    @Override
    public List<JsonNode> findValues(String fieldName, List<JsonNode> foundSoFar) {
        return foundSoFar;
    }

    @Override
    public List<String> findValuesAsString(String fieldName, List<String> foundSoFar) {
        return foundSoFar;
    }

    @Override
    public List<JsonNode> findParents(String fieldName, List<JsonNode> foundSoFar) {
        return foundSoFar;
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeNull();
    }

    @Override
    public void serializeWithType(JsonGenerator g, SerializationContext provider, TypeSerializer typeSer) throws JacksonException {
        g.writeNull();
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    @Override
    public int hashCode() {
        return JsonNodeType.MISSING.ordinal();
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    public String toPrettyString() {
        return "";
    }
}

