/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.reflect.Method;
import java.util.Arrays;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.proxy.HashUtil;

@DisableTrace
class MethodSignature {
    private final String name;
    private final Class[] parameterTypes;
    private final Class returnType;
    private Integer hashCode = null;

    MethodSignature(Method method) {
        this.name = method.getName();
        this.parameterTypes = method.getParameterTypes();
        this.returnType = method.getReturnType();
    }

    MethodSignature(String string, Class[] classArray, Class clazz) {
        this.name = string;
        this.parameterTypes = classArray;
        this.returnType = clazz;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!(object instanceof MethodSignature)) {
            return false;
        }
        MethodSignature methodSignature = (MethodSignature)object;
        if (this == methodSignature) {
            return true;
        }
        if (!this.name.equals(methodSignature.name)) {
            return false;
        }
        if (!Arrays.deepEquals(this.parameterTypes, methodSignature.parameterTypes)) {
            return false;
        }
        if (null != this.returnType && null != methodSignature.returnType && !this.returnType.equals(methodSignature.returnType)) {
            throw new RuntimeException("methods \"" + this.name + "\" have the same signature \"" + this.parameterTypes + "\" but different return types: \"" + this.returnType + "\" and \"" + methodSignature.returnType + "\"");
        }
        return true;
    }

    public int hashCode() {
        if (null == this.hashCode) {
            this.hashCode = new Integer(23);
            this.hashCode = HashUtil.hash((int)this.hashCode, this.name);
            this.hashCode = HashUtil.hash((int)this.hashCode, this.parameterTypes);
        }
        return this.hashCode;
    }

    String getName() {
        return this.name;
    }

    Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    Class getReturnType() {
        return this.returnType;
    }
}

