/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.tuners.stats;

import java.lang.reflect.Executable;
import java.util.List;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.tuners.stats.Histogram;
import oracle.ucp.tuners.stats.HistogramInsertionException;
import oracle.ucp.tuners.stats.HistogramRegistry;
import oracle.ucp.tuners.stats.RingRegistry;
import oracle.ucp.util.RingBuffer;

@DefaultLogger(value="oracle.ucp.tuners")
@Supports(value={Feature.ADMIN})
public class HistogramRingRegistry
implements RingRegistry {
    private final long min;
    private final long max;
    private final long step;
    private final RingBuffer<HistogramRegistry> ringBuffer;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    public HistogramRingRegistry(int maxFrames, long min, long max, long step) {
        this.ringBuffer = new RingBuffer(maxFrames);
        this.min = min;
        this.max = max;
        this.step = step;
        this.turnRing();
    }

    public void insert(ConnectionRetrievalInfo cri, long time) {
        try {
            this.ringBuffer.getAsList().get(0).getHistogram(cri).insert(Math.max(this.min, Math.min(this.max - 1L, time)));
        }
        catch (HistogramInsertionException e2) {
            ClioSupport.ilogThrowing(null, null, null, null, e2);
        }
    }

    @Override
    public void turnRing() {
        this.ringBuffer.addItem(new HistogramRegistry(this.min, this.max, this.step));
    }

    @Override
    public HistogramRegistry collect() {
        HistogramRegistry collectedRegistry = new HistogramRegistry(this.min, this.max, this.step);
        List<HistogramRegistry> listRegistry = this.ringBuffer.getAsList();
        listRegistry.forEach(p2 -> this.collect(collectedRegistry, (HistogramRegistry)p2));
        return collectedRegistry;
    }

    private void collect(HistogramRegistry collectedHreg, HistogramRegistry hreg) {
        hreg.forEach((cri, hist) -> this.collect(collectedHreg, (ConnectionRetrievalInfo)cri, (Histogram)hist));
    }

    private void collect(HistogramRegistry collectedHreg, ConnectionRetrievalInfo cri, Histogram hist) {
        collectedHreg.getHistogram(cri).add(hist);
    }

    @Override
    public HistogramRingRegistry merge(HistogramRingRegistry that) {
        HistogramRingRegistry reg = new HistogramRingRegistry(this.ringBuffer.getCapacity() + that.ringBuffer.getCapacity(), this.min, this.max, this.step);
        this.ringBuffer.getAsList().forEach(p2 -> reg.ringBuffer.addItem((HistogramRegistry)p2));
        that.ringBuffer.getAsList().forEach(p2 -> reg.ringBuffer.addItem((HistogramRegistry)p2));
        return reg;
    }

    @Override
    public HistogramRingRegistry merge(HistogramRegistry histReg) {
        HistogramRingRegistry reg = new HistogramRingRegistry(this.ringBuffer.getCapacity() + 1, this.min, this.max, this.step);
        this.ringBuffer.getAsList().forEach(p2 -> reg.ringBuffer.addItem((HistogramRegistry)p2));
        reg.ringBuffer.addItem(histReg);
        return reg;
    }

    static {
        try {
            $$$methodRef$$$12 = HistogramRingRegistry.class.getDeclaredConstructor(Integer.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$11 = HistogramRingRegistry.class.getDeclaredMethod("lambda$collect$0", HistogramRegistry.class, HistogramRegistry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$10 = HistogramRingRegistry.class.getDeclaredMethod("lambda$collect$1", HistogramRegistry.class, ConnectionRetrievalInfo.class, Histogram.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$9 = HistogramRingRegistry.class.getDeclaredMethod("lambda$merge$2", HistogramRingRegistry.class, HistogramRegistry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$8 = HistogramRingRegistry.class.getDeclaredMethod("lambda$merge$3", HistogramRingRegistry.class, HistogramRegistry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$7 = HistogramRingRegistry.class.getDeclaredMethod("lambda$merge$4", HistogramRingRegistry.class, HistogramRegistry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$6 = HistogramRingRegistry.class.getDeclaredMethod("merge", HistogramRegistry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$5 = HistogramRingRegistry.class.getDeclaredMethod("merge", HistogramRingRegistry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$4 = HistogramRingRegistry.class.getDeclaredMethod("collect", HistogramRegistry.class, ConnectionRetrievalInfo.class, Histogram.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$3 = HistogramRingRegistry.class.getDeclaredMethod("collect", HistogramRegistry.class, HistogramRegistry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$2 = HistogramRingRegistry.class.getDeclaredMethod("collect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$1 = HistogramRingRegistry.class.getDeclaredMethod("turnRing", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$0 = HistogramRingRegistry.class.getDeclaredMethod("insert", ConnectionRetrievalInfo.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
    }
}

