/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class Util {
    static final Pattern onsMaskPattern = Pattern.compile("(walletfile=|walletpassword=).*(\n|$)");
    public static int PLANNED_DRAINING_INTERVAL = 5;

    public static boolean sameOrEqual(Object o1, Object o2) {
        return o1 == o2 || null != o1 && o1.equals(o2);
    }

    public static String maskONSConfigurationString(String onsConfigStr) {
        return onsConfigStr == null || "".equals(onsConfigStr) ? "" : onsMaskPattern.matcher(onsConfigStr).replaceAll("*****");
    }

    public static boolean isAffinityStrict() {
        try {
            return "true".equals(((String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public Object run() {
                    return System.getProperty("oracle.ucp.jdbc.oracle.affinity.strict", "false");
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            })).trim().toLowerCase());
        }
        catch (PrivilegedActionException e2) {
            return false;
        }
    }

    public static int getMaxInitThreads() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public Integer run() {
                    return Math.max(0, Integer.parseInt(System.getProperty("oracle.ucp.MaxInitThreads", "4").trim()));
                }

                static {
                    try {
                        $$$methodRef$$$2 = 2.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$1 = 2.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
        catch (PrivilegedActionException e2) {
            return 4;
        }
    }

    public static boolean isPreWLS1212Compatible() {
        try {
            return "true".equals(((String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public Object run() {
                    return System.getProperty("oracle.ucp.PreWLS1212Compatible", "false");
                }

                static {
                    try {
                        $$$methodRef$$$1 = 3.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 3.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            })).trim().toLowerCase());
        }
        catch (PrivilegedActionException e2) {
            return false;
        }
    }

    public static int getPlannedDrainingPeriod() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public Integer run() {
                    return Integer.parseInt(System.getProperty("oracle.ucp.PlannedDrainingPeriod", "0"));
                }

                static {
                    try {
                        $$$methodRef$$$2 = 4.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$1 = 4.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 4.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
        catch (PrivilegedActionException e2) {
            return 0;
        }
    }

    public static void disableDriverHA() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public Object run() {
                    return System.setProperty("oracle.jdbc.fanEnabled", "false");
                }

                static {
                    try {
                        $$$methodRef$$$1 = 5.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 5.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    public static void disableImplicitBeginRequest() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public Object run() {
                    return System.setProperty("oracle.jdbc.beginRequestAtConnectionCreation", "false");
                }

                static {
                    try {
                        $$$methodRef$$$1 = 6.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 6.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    public static String getXMLConfigurationFilePath() throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public String run() {
                return System.getProperty("oracle.ucp.jdbc.xmlConfigFile");
            }

            static {
                try {
                    $$$methodRef$$$2 = 7.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 7.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 7.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    public static String getReadOnlyInstanceAllowed() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public String run() {
                    return System.getProperty("oracle.jdbc.readOnlyInstanceAllowed", "false");
                }

                static {
                    try {
                        $$$methodRef$$$2 = 8.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$1 = 8.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 8.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
        catch (PrivilegedActionException e2) {
            return "false";
        }
    }

    public static String getShardRoutingEnabled() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public String run() {
                    return System.getProperty("oracle.jdbc.enableShardRouting", "true");
                }

                static {
                    try {
                        $$$methodRef$$$2 = 9.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$1 = 9.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 9.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
        catch (PrivilegedActionException e2) {
            return "true";
        }
    }

    public static boolean isDestroyOnReloadEnabled() {
        try {
            return "true".equals(((String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public String run() {
                    return System.getProperty("oracle.ucp.destroyOnReload", "false");
                }

                static {
                    try {
                        $$$methodRef$$$2 = 10.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$1 = 10.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 10.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            })).trim().toLowerCase());
        }
        catch (PrivilegedActionException e2) {
            return false;
        }
    }

    public static boolean equalsNormalized(String item1, String item2) {
        if (null == item1) {
            return null == item2;
        }
        if (null == item2) {
            return false;
        }
        return item1.trim().toLowerCase().equals(item2.trim().toLowerCase());
    }

    public static boolean isSelfTunerEnabled() {
        try {
            return "false".equals(((String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public Object run() {
                    return System.getProperty("oracle.ucp.selftuning", "true");
                }

                static {
                    try {
                        $$$methodRef$$$1 = 11.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 11.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            })).trim().toLowerCase());
        }
        catch (PrivilegedActionException e2) {
            return false;
        }
    }
}

