/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.db.client;

import co.kuali.coeus.data.migration.FlywayMigrator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;

public class FlywayClient {
    private static final String COEUS_DATASOURCE = "coeusDataSource";
    private static final String RICE_DATASOURCE = "riceDataSource";
    private static final String DRIVER_NAME = "driverName";
    private static final String URL = "url";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String APPLY_DEMO = "applyDemo";
    private static final String APPLY_STAGING = "applyStaging";
    private static final String GRM = "grm";
    private static final String ENABLED = "enabled";
    private static final String SQL_MIGRATION_PATH = "sqlMigrationPath";
    private static final String JAVA_MIGRATION_PATH = "javaMigrationPath";
    private static final String INIT_VERSION = "initVersion";
    private static final Logger LOG = Logger.getLogger(FlywayClient.class.getName());

    public static void main(String[] args) throws IOException {
        FlywayClient.initLogging("jul-default.properties");
        HashMap input = new ObjectMapper().readValue(System.in, HashMap.class);
        new FlywayClient().apply(input);
    }

    protected void apply(Map<String, Object> input) {
        LOG.info("Starting Flyway Migrator");
        Map coeusDataSourceInput = (Map)input.get(COEUS_DATASOURCE);
        String coeusDriverName = (String)coeusDataSourceInput.get(DRIVER_NAME);
        String coeusUrl = (String)coeusDataSourceInput.get(URL);
        String coeusUsername = (String)coeusDataSourceInput.get(USERNAME);
        String coeusPassword = (String)coeusDataSourceInput.get(PASSWORD);
        Map riceDataSourceInput = (Map)input.get(RICE_DATASOURCE);
        String riceDriverName = (String)riceDataSourceInput.get(DRIVER_NAME);
        String riceUrl = (String)riceDataSourceInput.get(URL);
        String riceUsername = (String)riceDataSourceInput.get(USERNAME);
        String ricePassword = (String)riceDataSourceInput.get(PASSWORD);
        Boolean applyDemo = (Boolean)input.get(APPLY_DEMO);
        Boolean applyStaging = (Boolean)input.get(APPLY_STAGING);
        Boolean grm = (Boolean)input.get(GRM);
        Boolean enabled = (Boolean)input.get(ENABLED);
        String sqlMigrationPath = (String)input.get(SQL_MIGRATION_PATH);
        String javaMigrationPath = (String)input.get(JAVA_MIGRATION_PATH);
        String initVersion = (String)input.get(INIT_VERSION);
        FlywayMigrator migrator = new FlywayMigrator();
        migrator.setDataSource(this.retrieveDataSource(coeusDriverName, coeusUrl, coeusUsername, coeusPassword));
        migrator.setRiceDataSource(this.retrieveDataSource(riceDriverName, riceUrl, riceUsername, ricePassword));
        migrator.setManageRice(true);
        migrator.setEmbeddedMode(false);
        migrator.setApplyDemo(applyDemo);
        migrator.setApplyStaging(applyStaging);
        migrator.setGrm(grm);
        migrator.setEnabled(enabled);
        migrator.setSqlMigrationPath(sqlMigrationPath);
        migrator.setJavaMigrationPath(javaMigrationPath);
        migrator.setInitVersion(initVersion);
        migrator.migrate();
        LOG.info("SUCCESS");
    }

    private DataSource retrieveDataSource(String driverName, String url, String username, String password) {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.addConnectionProperty("serverTimezone", "UTC");
        dataSource.setDefaultAutoCommit(false);
        dataSource.setEnableAutoCommitOnReturn(false);
        dataSource.setDriverClassName(driverName);
        dataSource.setUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        return dataSource;
    }

    private static void initLogging(String file) {
        String fname = System.getProperty("java.util.logging.config.file");
        if (fname == null || !new File(fname).isFile()) {
            try (BufferedInputStream in = new BufferedInputStream(FlywayClient.class.getResourceAsStream(file));){
                LogManager.getLogManager().readConfiguration(in);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

