/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.XAConnection;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.ClientDataSupport;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Clock;
import oracle.ucp.jdbc.ConnectionWithAbandonedTimeout;
import oracle.ucp.jdbc.ConnectionWithTimeToLiveTimeout;
import oracle.ucp.jdbc.HarvestableConnection;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;
import oracle.ucp.jdbc.oracle.Poolable;
import oracle.ucp.jdbc.proxy.Creator;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.oracle.StatementProxy;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.Chain;
import oracle.ucp.util.MapChain;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
abstract class ConnectionProxyBase
implements LabelableConnection,
HarvestableConnection,
ConnectionWithAbandonedTimeout,
ConnectionWithTimeToLiveTimeout,
ValidConnection,
XAConnection,
LogicalObject,
Poolable,
ClientDataSupport {
    protected final long creationTS = Clock.clock();
    final AtomicBoolean closed = new AtomicBoolean(false);
    protected final AtomicBoolean actuallyReturned = new AtomicBoolean(false);
    protected Chain<StatementProxy> statementsToClose = new MapChain<StatementProxy>();

    ConnectionProxyBase() {
    }

    UniversalPooledConnection getUPC() {
        Object c2 = this.getCreator();
        return c2 instanceof Creator ? ((Creator)c2).getUPC() : ((ConnectionProxyBase)c2).getUPC();
    }

    UniversalConnectionPool getUCP() {
        Object c2 = this.getCreator();
        return c2 instanceof Creator ? ((Creator)c2).getUCP() : ((ConnectionProxyBase)c2).getUCP();
    }

    protected abstract Connection getDelegate();

    protected abstract Object getCreator();

    protected void handleSQRecoverableException(SQLException e2) throws SQLException {
        if (e2 instanceof SQLRecoverableException && !this.actuallyReturned.get()) {
            try {
                for (StatementProxy stmt : this.statementsToClose.toList()) {
                    stmt.close();
                }
                this.statementsToClose.clear();
                this.getUPC().setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.getUCP().returnConnection(this.getUPC());
                this.actuallyReturned.set(true);
                this.closed.set(true);
            }
            catch (UniversalConnectionPoolException ucpe) {
                ClioSupport.ilogThrowing(null, null, null, null, ucpe);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        UniversalConnectionPool ucp = this.getUCP();
        UniversalPooledConnection upc = this.getUPC();
        upc.heartbeat();
        if (this.closed.get()) {
            return;
        }
        try {
            for (StatementProxy stmt : this.statementsToClose.toList()) {
                stmt.close();
            }
            this.statementsToClose.clear();
            this.closed.set(true);
            ucp.returnConnection(upc);
            this.actuallyReturned.set(true);
            upc.heartbeat();
        }
        catch (UniversalConnectionPoolException e2) {
            Throwable cause = e2.getCause();
            if (null == cause) {
                throw new SQLException(e2);
            }
            Throwable cause2 = cause.getCause();
            if (null == cause2 || !(cause2 instanceof SQLException)) {
                throw new SQLException(e2);
            }
            throw (SQLException)cause2;
        }
    }

    public void close(int code) throws SQLException {
        ConnectionRetrievalInfo cri;
        UniversalPooledConnection upc = this.getUPC();
        upc.heartbeat();
        ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).close(code);
        if (1 == code && (cri = upc.getConnectionRetrievalInfo()) instanceof JDBCConnectionRetrievalInfo) {
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            upc.setConnectionRetrievalInfo(jdbcCri.getCopyWithNewProxyProperties(-1, null));
        }
        upc.heartbeat();
    }

    public void close(Properties props) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        upc.heartbeat();
        ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).close(props);
        upc.heartbeat();
    }

    public boolean isUsable() {
        if (this.closed.get()) {
            return false;
        }
        return ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).isUsable();
    }

    public boolean isValid(int timeout) throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        return this.getDelegate().isValid(timeout);
    }

    public boolean isValid(OracleConnection.ConnectionValidation effort, int timeout) throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        return ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).isValid(effort, timeout);
    }

    @Override
    public boolean isValid() throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        return this.getUPC().isValid();
    }

    @Override
    public void setInvalid() throws SQLException {
        this.getUPC().heartbeat();
        try {
            this.getUPC().setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
        }
        catch (UniversalConnectionPoolException e2) {
            throw new SQLException(e2);
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.closed.get()) {
            return true;
        }
        return this.getDelegate().isClosed();
    }

    @Override
    public UniversalPooledConnection getPooledObject() {
        return this.getUPC();
    }

    @Override
    public boolean isLogicallyClosed() {
        return this.closed.get();
    }

    @Override
    public void applyConnectionLabel(String key, String value) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().applyConnectionLabel(key, value);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(32, ucpExc);
        }
    }

    @Override
    public void removeConnectionLabel(String key) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeConnectionLabel(key);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(33, ucpExc);
        }
    }

    @Override
    public Properties getConnectionLabels() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        Properties props = null;
        try {
            props = this.getUPC().getConnectionLabels();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(34, ucpExc);
        }
        return props;
    }

    @Override
    public Properties getUnmatchedConnectionLabels(Properties requestedLabels) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        Properties props = null;
        try {
            props = this.getUPC().getUnmatchedConnectionLabels(requestedLabels);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(35, ucpExc);
        }
        return props;
    }

    @Override
    public void setConnectionHarvestable(boolean isConnectionHarvestable) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().setConnectionHarvestable(isConnectionHarvestable);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(36, ucpExc);
        }
    }

    @Override
    public boolean isConnectionHarvestable() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        return this.getUPC().isConnectionHarvestable();
    }

    @Override
    public void registerConnectionHarvestingCallback(ConnectionHarvestingCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().registerConnectionHarvestingCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(37, ucpExc);
        }
    }

    @Override
    public void removeConnectionHarvestingCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeConnectionHarvestingCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(38, ucpExc);
        }
    }

    @Override
    public void registerAbandonedConnectionTimeoutCallback(AbandonedConnectionTimeoutCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().registerAbandonedConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(39, ucpExc);
        }
    }

    @Override
    public void removeAbandonedConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeAbandonedConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(40, ucpExc);
        }
    }

    @Override
    public void registerTimeToLiveConnectionTimeoutCallback(TimeToLiveConnectionTimeoutCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().registerTimeToLiveConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(41, ucpExc);
        }
    }

    @Override
    public void removeTimeToLiveConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeTimeToLiveConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(42, ucpExc);
        }
    }

    public boolean equals(Object thatObj) {
        if (null == thatObj) {
            return false;
        }
        if (this == thatObj) {
            return true;
        }
        return this.getDelegate().equals(thatObj instanceof ConnectionProxyBase ? ((ConnectionProxyBase)thatObj).getDelegate() : thatObj);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public Object getClientData(Object obj) {
        return ((OracleConnection)this.getDelegate()).getClientData(obj);
    }

    @Override
    public Object setClientData(Object obj1, Object obj2) {
        return ((OracleConnection)this.getDelegate()).setClientData(obj1, obj2);
    }

    @Override
    public Object removeClientData(Object obj) {
        return ((OracleConnection)this.getDelegate()).removeClientData(obj);
    }

    protected void saveStatementProxy(Object result) {
        if (result instanceof StatementProxy) {
            StatementProxy statementProxy = (StatementProxy)result;
            statementProxy.setStatementChainAtom(this.statementsToClose.add(statementProxy));
        }
    }
}

