/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.migration.MigrationChecksumProvider;
import org.flywaydb.core.api.migration.MigrationInfoProvider;
import org.flywaydb.core.api.migration.jdbc.JdbcMigration;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.resolver.MigrationInfoHelper;
import org.flywaydb.core.internal.resolver.ResolvedMigrationComparator;
import org.flywaydb.core.internal.resolver.ResolvedMigrationImpl;
import org.flywaydb.core.internal.resolver.jdbc.JdbcMigrationExecutor;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.Location;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.scanner.Scanner;

public class JdbcMigrationResolver
implements MigrationResolver {
    private final Location location;
    private ClassLoader classLoader;

    public JdbcMigrationResolver(ClassLoader classLoader, Location location) {
        this.location = location;
        this.classLoader = classLoader;
    }

    public List<ResolvedMigration> resolveMigrations() {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        if (!this.location.isClassPath()) {
            return migrations;
        }
        try {
            Class<?>[] classes;
            for (Class<?> clazz : classes = new Scanner(this.classLoader).scanForClasses(this.location, JdbcMigration.class)) {
                JdbcMigration jdbcMigration = (JdbcMigration)ClassUtils.instantiate(clazz.getName(), this.classLoader);
                ResolvedMigrationImpl migrationInfo = this.extractMigrationInfo(jdbcMigration);
                migrationInfo.setPhysicalLocation(ClassUtils.getLocationOnDisk(clazz));
                migrationInfo.setExecutor(new JdbcMigrationExecutor(jdbcMigration));
                migrations.add(migrationInfo);
            }
        }
        catch (Exception e2) {
            throw new FlywayException("Unable to resolve Jdbc Java migrations in location: " + this.location, e2);
        }
        Collections.sort(migrations, new ResolvedMigrationComparator());
        return migrations;
    }

    ResolvedMigrationImpl extractMigrationInfo(JdbcMigration jdbcMigration) {
        String description;
        MigrationVersion version;
        Integer checksum = null;
        if (jdbcMigration instanceof MigrationChecksumProvider) {
            MigrationChecksumProvider checksumProvider = (MigrationChecksumProvider)((Object)jdbcMigration);
            checksum = checksumProvider.getChecksum();
        }
        if (jdbcMigration instanceof MigrationInfoProvider) {
            MigrationInfoProvider infoProvider = (MigrationInfoProvider)((Object)jdbcMigration);
            version = infoProvider.getVersion();
            description = infoProvider.getDescription();
            if (!StringUtils.hasText(description)) {
                throw new FlywayException("Missing description for migration " + version);
            }
        } else {
            Pair<MigrationVersion, String> info = MigrationInfoHelper.extractVersionAndDescription(ClassUtils.getShortName(jdbcMigration.getClass()), "V", "__", "");
            version = info.getLeft();
            description = info.getRight();
        }
        String script = jdbcMigration.getClass().getName();
        ResolvedMigrationImpl resolvedMigration = new ResolvedMigrationImpl();
        resolvedMigration.setVersion(version);
        resolvedMigration.setDescription(description);
        resolvedMigration.setScript(script);
        resolvedMigration.setChecksum(checksum);
        resolvedMigration.setType(MigrationType.JDBC);
        return resolvedMigration;
    }
}

