/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.logging.runtime;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.runtime.Features;
import oracle.ucp.logging.runtime.TraceController;

@DisableTrace
public class TraceControllerImpl
implements TraceController {
    private static final Features features;
    private RuntimeException reSuspended = new IllegalStateException("trace controller is currently suspended");
    public static long feature;
    private static long backup;
    private static int suspends;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trace(boolean enable, Feature ... features) {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            if (0 != suspends) {
                throw this.reSuspended;
            }
            long fMask = 0L;
            for (Feature f2 : features) {
                fMask |= f2.bitVector();
            }
            feature = enable ? feature | fMask : feature & (fMask ^ 0xFFFFFFFFFFFFFFFFL);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] getEnabledFeatures() {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            if (0 != suspends) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new Feature[0];
            }
            ArrayList<Feature> enabledFeatures = new ArrayList<Feature>();
            if (feature == Feature.ALL.bitVector()) {
                enabledFeatures.add(Feature.ALL);
            } else {
                for (Feature f2 : this.getSupportedFeatures()) {
                    if (Feature.ALL == f2) continue;
                    if (0L == (feature & f2.bitVector())) continue;
                    enabledFeatures.add(f2);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return enabledFeatures.toArray(new Feature[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] getSupportedFeatures() {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            ArrayList<Feature> supportedFeatures = new ArrayList<Feature>();
            for (Feature feature : Feature.values()) {
                supportedFeatures.add(feature);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return supportedFeatures.toArray(new Feature[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            if (0 == suspends++) {
                backup = feature;
                feature = 0L;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            int s2 = --suspends;
            if (0 == s2) {
                feature = backup;
            } else if (s2 < 0) {
                suspends = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTracing(Feature ... supportedFeatures) {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            if (0 != suspends) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            boolean isTracing = true;
            for (Feature feature : supportedFeatures) {
                if (0L != (TraceControllerImpl.feature & feature.bitVector())) continue;
                isTracing = false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return isTracing;
        }
    }

    static {
        String trace;
        try {
            $$$methodRef$$$6 = TraceControllerImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = TraceControllerImpl.class.getDeclaredMethod("isTracing", Feature[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = TraceControllerImpl.class.getDeclaredMethod("resume", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = TraceControllerImpl.class.getDeclaredMethod("suspend", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = TraceControllerImpl.class.getDeclaredMethod("getSupportedFeatures", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = TraceControllerImpl.class.getDeclaredMethod("getEnabledFeatures", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = TraceControllerImpl.class.getDeclaredMethod("trace", Boolean.TYPE, Feature[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        features = new Features("oracle.ucp.logging.annotations.Supports");
        feature = Feature.ALL_UCP.bitVector();
        String prop = System.getProperty("oracle.jdbc.Trace");
        if (null != prop && ("true".equals(trace = prop.trim().toLowerCase()) || "on".equals(trace))) {
            feature |= Feature.ALL_JDBC.bitVector();
        }
        String PREFIX = "clio.feature";
        String configFile = System.getProperty("java.util.logging.config.file");
        if (null != configFile) {
            Properties props = new Properties();
            InputStream inputStream = TraceControllerImpl.class.getClassLoader().getResourceAsStream(configFile);
            if (null == inputStream) {
                try {
                    inputStream = new FileInputStream(configFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (null != inputStream) {
                try {
                    props.load(inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            long selectedFeature = 0L;
            for (Feature f2 : Feature.values()) {
                String key = "clio.feature." + f2.toString().toLowerCase();
                String value = props.getProperty(key);
                if (null == value) continue;
                String v2 = value.toLowerCase().trim();
                if ("on".equals(v2) || "true".equals(v2)) {
                    selectedFeature |= f2.bitVector();
                    continue;
                }
                if (!"off".equals(v2) && !"false".equals(v2)) continue;
                selectedFeature &= f2.bitVector() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (0L != selectedFeature) {
                feature = selectedFeature;
            }
        }
        backup = 0L;
        suspends = 0;
    }
}

