/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.common.Selector;

@DisableTrace
public class Selectors {
    public static final Selector NONE = conn -> false;
    public static final Selector EVERY = conn -> true;

    public static final Selector not(Selector selector) {
        return conn -> !selector.selected(conn);
    }

    public static Selector and(Selector ... selectors) {
        return conn -> {
            boolean result = true;
            for (Selector selector : selectors) {
                boolean bl = result = result && selector.selected(conn);
                if (!result) break;
            }
            return result;
        };
    }

    public static Selector or(Selector ... selectors) {
        return conn -> {
            boolean result = false;
            for (Selector selector : selectors) {
                boolean bl = result = result || selector.selected(conn);
                if (result) break;
            }
            return result;
        };
    }
}

