/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.data.migration.custom;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.MigrationExecutor;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.RegexPatternTypeFilter;

public class CoeusMigrationResolver
implements MigrationResolver {
    protected DataSource riceDataSource;
    protected String javaMigrationPath;

    public Set<ResolvedMigration> resolveMigrations() {
        HashSet<ResolvedMigration> migrations = new HashSet<ResolvedMigration>();
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(true);
        provider.addIncludeFilter(new RegexPatternTypeFilter(Pattern.compile(".*")));
        Set<BeanDefinition> components = provider.findCandidateComponents(this.pathToPackage(this.javaMigrationPath));
        for (BeanDefinition component : components) {
            try {
                Class<?> clazz = Class.forName(component.getBeanClassName());
                if (!this.isMigratorCompatible(clazz)) continue;
                Object migration = clazz.newInstance();
                if (this.containsSetRiceDataSource(clazz)) {
                    this.execSetRiceDataSource(migration, this.riceDataSource);
                }
                migrations.add(new GenericMigrationAdapter(migration));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e2) {
                throw new RuntimeException(e2);
            }
        }
        return migrations;
    }

    private String pathToPackage(String path) {
        String pkg = path.replaceAll("/", ".");
        while (pkg.endsWith(".")) {
            pkg = StringUtils.removeEnd(pkg, ".");
        }
        return pkg;
    }

    private boolean isMigratorCompatible(Class<?> c2) {
        try {
            c2.getMethod("executeInTransaction", new Class[0]);
            c2.getMethod("execute", Connection.class);
        }
        catch (NoSuchMethodException e2) {
            return false;
        }
        return true;
    }

    private boolean containsSetRiceDataSource(Class<?> c2) {
        try {
            c2.getMethod("setRiceDataSource", DataSource.class);
        }
        catch (NoSuchMethodException e2) {
            return false;
        }
        return true;
    }

    private void execSetRiceDataSource(Object o2, DataSource riceDataSource) {
        try {
            Method setRiceDataSource = o2.getClass().getMethod("setRiceDataSource", DataSource.class);
            setRiceDataSource.invoke(o2, riceDataSource);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
            throw new RuntimeException(e2);
        }
    }

    public CoeusMigrationResolver() {
    }

    public CoeusMigrationResolver(DataSource riceDataSource) {
        this.riceDataSource = riceDataSource;
    }

    public DataSource getRiceDataSource() {
        return this.riceDataSource;
    }

    public void setRiceDataSource(DataSource riceDataSource) {
        this.riceDataSource = riceDataSource;
    }

    public String getJavaMigrationPath() {
        return this.javaMigrationPath;
    }

    public void setJavaMigrationPath(String javaMigrationPath) {
        this.javaMigrationPath = javaMigrationPath;
    }

    private static class GenericMigrationAdapter
    implements ResolvedMigration,
    MigrationExecutor {
        private Object migration;

        private GenericMigrationAdapter(Object o2) {
            this.migration = o2;
        }

        @Override
        public void execute(Connection connection) throws SQLException {
            try {
                Method execute = this.migration.getClass().getMethod("execute", Connection.class);
                execute.invoke(this.migration, connection);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
                throw new RuntimeException(e2);
            }
        }

        @Override
        public boolean executeInTransaction() {
            try {
                Method executeInTransaction = this.migration.getClass().getMethod("executeInTransaction", new Class[0]);
                return (Boolean)executeInTransaction.invoke(this.migration, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
                throw new RuntimeException(e2);
            }
        }

        @Override
        public Integer getChecksum() {
            return null;
        }

        @Override
        public String getPhysicalLocation() {
            return this.migration.getClass().getCanonicalName();
        }

        @Override
        public String getScript() {
            return this.migration.getClass().getSimpleName();
        }

        @Override
        public MigrationType getType() {
            return MigrationType.CUSTOM;
        }

        @Override
        public MigrationVersion getVersion() {
            return MigrationVersion.fromVersion(this.migration.getClass().getSimpleName().split("__")[0].substring(1));
        }

        @Override
        public String getDescription() {
            return this.migration.getClass().getSimpleName().split("__")[1];
        }

        @Override
        public MigrationExecutor getExecutor() {
            return this;
        }
    }
}

