/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.vertica;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.Table;
import org.flywaydb.core.internal.dbsupport.Type;
import org.flywaydb.core.internal.dbsupport.postgresql.PostgreSQLTable;
import org.flywaydb.core.internal.dbsupport.vertica.VerticaDbSupport;

public class VerticaSchema
extends Schema<VerticaDbSupport> {
    public VerticaSchema(JdbcTemplate jdbcTemplate, VerticaDbSupport dbSupport, String name) {
        super(jdbcTemplate, dbSupport, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM v_catalog.schemata WHERE schema_name=?", this.name) > 0;
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        int objectCount = this.jdbcTemplate.queryForInt("SELECT count(*) FROM v_catalog.all_tables WHERE schema_name=? and table_type = 'TABLE'", this.name);
        return objectCount == 0;
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((VerticaDbSupport)this.dbSupport).quote(this.name), new Object[0]);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP SCHEMA " + ((VerticaDbSupport)this.dbSupport).quote(this.name) + " CASCADE", new Object[0]);
    }

    @Override
    protected void doClean() throws SQLException {
        for (String statement : this.generateDropStatementsForViews()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (Table table : this.allTables()) {
            table.drop();
        }
        for (String statement : this.generateDropStatementsForSequences()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForFunctions()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (Type type : this.allTypes()) {
            type.drop();
        }
    }

    private List<String> generateDropStatementsForSequences() throws SQLException {
        List<String> sequenceNames = this.jdbcTemplate.queryForStringList("SELECT sequence_name FROM v_catalog.sequences WHERE sequence_schema=?", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String sequenceName : sequenceNames) {
            statements.add("DROP SEQUENCE IF EXISTS " + ((VerticaDbSupport)this.dbSupport).quote(this.name, sequenceName));
        }
        return statements;
    }

    private List<String> generateDropStatementsForFunctions() throws SQLException {
        List<Map<String, String>> rows = this.jdbcTemplate.queryForList("select * from user_functions where schema_name = ? and procedure_type = 'User Defined Function'", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (Map<String, String> row : rows) {
            statements.add("DROP FUNCTION IF EXISTS " + ((VerticaDbSupport)this.dbSupport).quote(this.name, row.get("function_name")) + "(" + row.get("function_argument_type") + ")");
        }
        return statements;
    }

    private List<String> generateDropStatementsForViews() throws SQLException {
        List<String> viewNames = this.jdbcTemplate.queryForStringList("SELECT t.table_name FROM v_catalog.all_tables t WHERE schema_name=? and table_type = 'VIEW'", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String viewName : viewNames) {
            statements.add("DROP VIEW IF EXISTS " + ((VerticaDbSupport)this.dbSupport).quote(this.name, viewName));
        }
        return statements;
    }

    @Override
    protected Table[] doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("SELECT t.table_name FROM v_catalog.all_tables t WHERE schema_name=? and table_type =  'TABLE'", this.name);
        Table[] tables = new Table[tableNames.size()];
        for (int i2 = 0; i2 < tableNames.size(); ++i2) {
            tables[i2] = new PostgreSQLTable(this.jdbcTemplate, this.dbSupport, this, tableNames.get(i2));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new PostgreSQLTable(this.jdbcTemplate, this.dbSupport, this, tableName);
    }
}

