/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common.waitfreepool.kdtree;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.ucp.common.waitfreepool.kdtree.Range;

public class Point {
    private final Comparable[] coords;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    public Point(Comparable ... coords) {
        this.coords = coords;
    }

    public Point(Point point) {
        this.coords = new Comparable[point.coords.length];
        System.arraycopy(point.coords, 0, this.coords, 0, point.coords.length);
    }

    public boolean sameSpace(Point point) {
        int len = this.size();
        if (len != point.size()) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (this.coords[i2].getClass().equals(point.coords[i2].getClass())) continue;
            return false;
        }
        return true;
    }

    public boolean sameSpace(Range[] range) {
        int len = this.size();
        if (len != range.length) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (range[i2].infinite() || this.coords[i2].getClass().equals(range[i2].low().getClass())) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.coords.length;
    }

    public Comparable get(int index) {
        return this.coords[index];
    }

    public boolean within(Range[] range) {
        if (!this.sameSpace(range)) {
            throw new IllegalArgumentException("incompatible vectors");
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (range[i2].infinite() || this.coords[i2].compareTo(range[i2].low()) >= 0 && this.coords[i2].compareTo(range[i2].high()) <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Point that) {
        if (this.coords.length != that.coords.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.coords.length; ++i2) {
            if (null == this.coords[i2]) {
                if (null == that.coords[i2]) continue;
                return false;
            }
            if (this.coords[i2].equals(that.coords[i2])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i2 = 0; i2 < this.coords.length; ++i2) {
            sb.append(this.coords[i2]).append(i2 + 1 < this.coords.length ? ", " : "");
        }
        sb.append(']');
        return sb.toString();
    }

    static {
        try {
            $$$methodRef$$$8 = Point.class.getDeclaredConstructor(Point.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = Point.class.getDeclaredConstructor(Comparable[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = Point.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = Point.class.getDeclaredMethod("equals", Point.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = Point.class.getDeclaredMethod("within", Range[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = Point.class.getDeclaredMethod("get", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = Point.class.getDeclaredMethod("size", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = Point.class.getDeclaredMethod("sameSpace", Range[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = Point.class.getDeclaredMethod("sameSpace", Point.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

