/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.proxy;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.ucp.proxy.AnnotationsRegistry;
import oracle.ucp.proxy.GeneratedProxiesRegistry;
import oracle.ucp.proxy.MethodGenerator;
import oracle.ucp.proxy.MethodSignature;
import oracle.ucp.proxy.ProxyFactory;
import oracle.ucp.proxy.Utils;
import oracle.ucp.proxy._Proxy_;
import oracle.ucp.proxy.annotation.ProxyFor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class ClassGenerator {
    private final AnnotationsForIface annotationsForIface;
    private final String proxyName;
    private final String superclassName;
    private final String ifaceName;
    private final String proxyType;
    private final String ifaceType;
    final Map<MethodSignature, MethodGenerator> members;
    private final String proxyPackage;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    private ClassGenerator(AnnotationsForIface annotationsForIface, String proxyPackage, String proxyName, String superclassName, String ifaceName, Map<MethodSignature, MethodGenerator> members) {
        this.annotationsForIface = annotationsForIface;
        this.proxyPackage = proxyPackage;
        this.proxyName = Utils.makeSlashed(proxyName);
        this.proxyType = Utils.makeType(proxyName);
        this.superclassName = Utils.makeSlashed(superclassName);
        this.ifaceName = Utils.makeSlashed(ifaceName);
        this.ifaceType = Utils.makeType(ifaceName);
        this.members = members;
    }

    String getProxyName() {
        return this.proxyName;
    }

    String getSuperclassName() {
        return this.superclassName;
    }

    String getIfaceName() {
        return this.ifaceName;
    }

    String getProxyType() {
        return this.proxyType;
    }

    String getIfaceType() {
        return this.ifaceType;
    }

    static <T> byte[] generateBytecode(String proxyPackage, GeneratedProxiesRegistry.Key proxyName, AnnotationsRegistry annotationsRegistry) {
        Class iface = proxyName.getIface();
        final Class superclass = proxyName.getSuperclass();
        if (!iface.isInterface()) {
            new RuntimeException("iface must be interface");
        }
        if (superclass.isInterface()) {
            new RuntimeException("sclass must not be interface");
        }
        HashMap<MethodSignature, MethodGenerator> members = new HashMap<MethodSignature, MethodGenerator>();
        final HashMap methodsWithProxyFor = new HashMap();
        final HashMap methodsWithoutProxyFor = new HashMap();
        AnnotationsForIface annotationsForIface = new AnnotationsForIface(annotationsRegistry, iface, annotationsRegistry.get(iface));
        ClassGenerator classGenerator = new ClassGenerator(annotationsForIface, proxyPackage, proxyName.toString(), superclass.getName(), iface.getName(), members);
        new Runnable(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public void run() {
                this.traverse(superclass, superclass.isAnnotationPresent(ProxyFor.class));
            }

            void traverse(Class c2, boolean withProxyFor) {
                if (null == c2) {
                    return;
                }
                for (Method m2 : c2.getDeclaredMethods()) {
                    MethodSignature methodSignature = new MethodSignature(m2);
                    if (withProxyFor) {
                        methodsWithProxyFor.put(methodSignature, m2);
                        continue;
                    }
                    if (Modifier.isAbstract(m2.getModifiers())) continue;
                    methodsWithoutProxyFor.put(methodSignature, m2);
                }
                Class superclass2 = c2.getSuperclass();
                this.traverse(superclass2, withProxyFor && superclass2.isAnnotationPresent(ProxyFor.class));
            }

            static {
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredConstructor(Class.class, Map.class, Map.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("traverse", Class.class, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        }.run();
        int i2 = 0;
        for (Method method : iface.getMethods()) {
            MethodSignature methodSignature = new MethodSignature(method);
            Method superclassMethod = (Method)methodsWithProxyFor.get(methodSignature);
            if (null == superclassMethod && methodsWithoutProxyFor.containsKey(methodSignature)) continue;
            members.put(methodSignature, new MethodGenerator(classGenerator, method, null == superclassMethod || Modifier.isAbstract(superclassMethod.getModifiers()), i2++));
        }
        ClassWriter classWriter = new ClassWriter(3);
        classGenerator.generate(classWriter);
        byte[] bytecode = classWriter.toByteArray();
        String verify = System.getProperty("oracle.ucp.proxy.asm.verify", "false");
        if ("true".equals(verify.toLowerCase().trim())) {
            try {
                Class<?> checkClassAdapter = Class.forName("org.objectweb.asm.util.CheckClassAdapter");
                Method methodVerify = checkClassAdapter.getMethod("verify", ClassReader.class, Boolean.TYPE, PrintWriter.class);
                methodVerify.invoke(null, new ClassReader(bytecode), true, new PrintWriter(new OutputStreamWriter(System.out)));
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("failed to verify", ex);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException("failed to verify", ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("failed to verify", ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException("failed to verify", ex);
            }
        }
        return bytecode;
    }

    static <T> Class generate(String proxyPackage, Class<T> iface, Class superclass, AnnotationsRegistry annotationsRegistry, ClassLoader classLoader) {
        GeneratedProxiesRegistry.Key key = new GeneratedProxiesRegistry.Key(proxyPackage, iface, superclass);
        final byte[] bytecode = ClassGenerator.generateBytecode(proxyPackage, key, annotationsRegistry);
        try {
            final String clsName = key.toString();
            return Class.forName(clsName, false, new ClassLoader(null == classLoader ? superclass.getClassLoader() : classLoader){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                protected Class findClass(String name) {
                    if (name.equals(clsName)) {
                        return this.defineClass(name, bytecode, 0, bytecode.length);
                    }
                    throw new RuntimeException(new ClassNotFoundException(name));
                }

                static {
                    try {
                        $$$methodRef$$$1 = 2.class.getDeclaredConstructor(ClassLoader.class, String.class, byte[].class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("findClass", String.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void generate(ClassWriter classWriter) {
        MethodVisitor methodVisitor;
        classWriter.visit(50, 33, this.proxyName, null, this.superclassName, new String[]{this.ifaceName, Utils.makeSlashed(_Proxy_.class.getName())});
        ArrayList<MethodGenerator> methodGenerators = new ArrayList<MethodGenerator>(this.members.values());
        Collections.sort(methodGenerators, new Comparator<MethodGenerator>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public int compare(MethodGenerator methodGenerator1, MethodGenerator methodGenerator2) {
                return methodGenerator1.toString().compareTo(methodGenerator2.toString());
            }

            static {
                try {
                    $$$methodRef$$$2 = 3.class.getDeclaredConstructor(ClassGenerator.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredMethod("compare", Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("compare", MethodGenerator.class, MethodGenerator.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
        for (MethodGenerator methodGenerator : methodGenerators) {
            if (null == methodGenerator) continue;
            methodGenerator.generate(classWriter);
        }
        MethodVisitor methodVisitor2 = classWriter.visitMethod(1, "_getDelegate_", "()" + this.ifaceType, null, null);
        methodVisitor2.visitCode();
        methodVisitor2.visitVarInsn(25, 0);
        methodVisitor2.visitFieldInsn(180, this.proxyName, "delegate", this.ifaceType);
        methodVisitor2.visitInsn(176);
        methodVisitor2.visitMaxs(0, 0);
        methodVisitor2.visitEnd();
        methodVisitor2 = classWriter.visitMethod(4161, "_getDelegate_", "()Ljava/lang/Object;", null, null);
        methodVisitor2.visitCode();
        methodVisitor2.visitVarInsn(25, 0);
        methodVisitor2.visitMethodInsn(182, this.proxyName, "_getDelegate_", "()" + this.ifaceType);
        methodVisitor2.visitInsn(176);
        methodVisitor2.visitMaxs(0, 0);
        methodVisitor2.visitEnd();
        AnnotationsRegistry.Value value = this.annotationsForIface.getValue();
        if (null != value) {
            Method methodGetProxy;
            Method methodGetCreator;
            Label l1;
            Label l0;
            MethodVisitor methodVisitor3;
            Method methodSetDelegate;
            Method methodGetDelegate = value.getMethodGetDelegate();
            if (null != methodGetDelegate) {
                methodVisitor = classWriter.visitMethod(1, methodGetDelegate.getName(), "()" + Utils.makeType(methodGetDelegate.getReturnType()), null, null);
                methodVisitor.visitCode();
                Label l02 = new Label();
                methodVisitor.visitLabel(l02);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, this.proxyName, "delegate", this.ifaceType);
                methodVisitor.visitInsn(176);
                Label l12 = new Label();
                methodVisitor.visitLabel(l12);
                methodVisitor.visitLocalVariable("this", this.proxyType, null, l02, l12, 0);
                methodVisitor.visitMaxs(0, 0);
                methodVisitor.visitEnd();
            }
            if (null != (methodSetDelegate = value.getMethodSetDelegate())) {
                Class<?>[] parameterTypes = methodSetDelegate.getParameterTypes();
                if (1 != parameterTypes.length) {
                    throw new RuntimeException("wrong delegate setter signature");
                }
                methodVisitor3 = classWriter.visitMethod(1, methodSetDelegate.getName(), "(" + Utils.makeType(parameterTypes[0]) + ")V", null, null);
                methodVisitor3.visitCode();
                l0 = new Label();
                methodVisitor3.visitLabel(l0);
                methodVisitor3.visitVarInsn(25, 0);
                methodVisitor3.visitFieldInsn(180, this.proxyName, "proxyFactory", Utils.makeType(ProxyFactory.class));
                methodVisitor3.visitVarInsn(25, 0);
                methodVisitor3.visitVarInsn(25, 0);
                methodVisitor3.visitFieldInsn(180, this.proxyName, "delegate", this.ifaceType);
                methodVisitor3.visitVarInsn(25, 1);
                methodVisitor3.visitMethodInsn(182, Utils.makeSlashed(ProxyFactory.class), "updateDelegate", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V");
                methodVisitor3.visitVarInsn(25, 0);
                methodVisitor3.visitVarInsn(25, 1);
                methodVisitor3.visitFieldInsn(181, this.proxyName, "delegate", this.ifaceType);
                methodVisitor3.visitInsn(177);
                l1 = new Label();
                methodVisitor3.visitLabel(l1);
                methodVisitor3.visitLocalVariable("this", this.proxyType, null, l0, l1, 0);
                methodVisitor3.visitLocalVariable("delegate", this.ifaceType, null, l0, l1, 1);
                methodVisitor3.visitMaxs(0, 0);
                methodVisitor3.visitEnd();
            }
            if (null != (methodGetCreator = value.getMethodGetCreator())) {
                methodVisitor3 = classWriter.visitMethod(1, methodGetCreator.getName(), "()" + Utils.makeType(methodGetCreator.getReturnType()), null, null);
                methodVisitor3.visitCode();
                l0 = new Label();
                methodVisitor3.visitLabel(l0);
                methodVisitor3.visitVarInsn(25, 0);
                methodVisitor3.visitFieldInsn(180, this.proxyName, "creator", "Ljava/lang/Object;");
                methodVisitor3.visitInsn(176);
                l1 = new Label();
                methodVisitor3.visitLabel(l1);
                methodVisitor3.visitLocalVariable("this", this.proxyType, null, l0, l1, 0);
                methodVisitor3.visitMaxs(1, 1);
                methodVisitor3.visitEnd();
            }
            if (null != (methodGetProxy = value.getMethodGetProxy())) {
                Object[] parameterTypes = methodGetProxy.getParameterTypes();
                Class<?> returnType = methodGetProxy.getReturnType();
                if (!Arrays.deepEquals(new Class[]{Object.class, Object.class}, parameterTypes) || !Object.class.equals(returnType)) {
                    throw new RuntimeException("wrong @GetProxy method");
                }
                MethodVisitor methodVisitor4 = classWriter.visitMethod(1, methodGetProxy.getName(), "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "<T:Ljava/lang/Object;>(TT;Ljava/lang/Object;)TT;", null);
                methodVisitor4.visitCode();
                methodVisitor4.visitVarInsn(25, 0);
                methodVisitor4.visitFieldInsn(180, this.proxyName, "proxyFactory", Utils.makeType(ProxyFactory.class));
                methodVisitor4.visitVarInsn(25, 1);
                methodVisitor4.visitVarInsn(25, 2);
                methodVisitor4.visitMethodInsn(182, Utils.makeSlashed(ProxyFactory.class), "proxyFor", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                methodVisitor4.visitInsn(176);
                methodVisitor4.visitMaxs(3, 3);
                methodVisitor4.visitEnd();
            }
        }
        classWriter.visitField(2, "delegate", this.ifaceType, null, null).visitEnd();
        classWriter.visitField(18, "creator", "Ljava/lang/Object;", null, null).visitEnd();
        classWriter.visitField(18, "proxyFactory", Utils.makeType(ProxyFactory.class.getName()), null, null).visitEnd();
        classWriter.visitField(18, "proxyCache", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/Object;Ljava/lang/Object;>;", null).visitEnd();
        classWriter.visitField(10, "zeroLengthObjectArray", "[Ljava/lang/Object;", null, null).visitEnd();
        boolean initializeMethodObjects = false;
        for (MethodGenerator methodGenerator : methodGenerators) {
            classWriter.visitField(10, methodGenerator.getMethodObject(), "Ljava/lang/reflect/Method;", null, null).visitEnd();
            initializeMethodObjects = true;
        }
        MethodVisitor methodVisitor5 = classWriter.visitMethod(8, "<clinit>", "()V", null, null);
        methodVisitor5.visitCode();
        Utils.loadConst(methodVisitor5, 0);
        methodVisitor5.visitTypeInsn(189, "java/lang/Object");
        methodVisitor5.visitFieldInsn(179, this.proxyName, "zeroLengthObjectArray", "[Ljava/lang/Object;");
        if (initializeMethodObjects) {
            Label l_tryBegin = new Label();
            Label l_tryEnd = new Label();
            Label l_catchBegin = new Label();
            methodVisitor5.visitTryCatchBlock(l_tryBegin, l_tryEnd, l_catchBegin, "java/lang/Throwable");
            methodVisitor5.visitLabel(l_tryBegin);
            for (MethodGenerator methodGenerator : methodGenerators) {
                methodGenerator.initializeMethodObject(methodVisitor5);
            }
            methodVisitor5.visitLabel(l_tryEnd);
            Label l_return = new Label();
            methodVisitor5.visitJumpInsn(167, l_return);
            methodVisitor5.visitLabel(l_catchBegin);
            methodVisitor5.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
            methodVisitor5.visitVarInsn(58, 0);
            methodVisitor5.visitTypeInsn(187, "java/lang/RuntimeException");
            methodVisitor5.visitInsn(89);
            methodVisitor5.visitVarInsn(25, 0);
            methodVisitor5.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/Throwable;)V");
            methodVisitor5.visitInsn(191);
            methodVisitor5.visitLabel(l_return);
            methodVisitor5.visitFrame(3, 0, null, 0, null);
        }
        methodVisitor5.visitInsn(177);
        methodVisitor5.visitMaxs(0, 0);
        methodVisitor5.visitEnd();
        String signature = "(" + this.ifaceType + "Ljava/lang/Object;" + Utils.makeType(ProxyFactory.class.getName()) + "Ljava/util/Map;)V";
        methodVisitor = classWriter.visitMethod(1, "<init>", signature, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, this.superclassName, "<init>", "()V");
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, this.proxyName, "delegate", this.ifaceType);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitFieldInsn(181, this.proxyName, "creator", "Ljava/lang/Object;");
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitFieldInsn(181, this.proxyName, "proxyFactory", Utils.makeType(ProxyFactory.class.getName()));
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitFieldInsn(181, this.proxyName, "proxyCache", "Ljava/util/Map;");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
    }

    AnnotationsForIface getAnnotationsForIface() {
        return this.annotationsForIface;
    }

    static {
        try {
            $$$methodRef$$$9 = ClassGenerator.class.getDeclaredConstructor(AnnotationsForIface.class, String.class, String.class, String.class, String.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = ClassGenerator.class.getDeclaredMethod("getAnnotationsForIface", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = ClassGenerator.class.getDeclaredMethod("generate", ClassWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = ClassGenerator.class.getDeclaredMethod("generate", String.class, Class.class, Class.class, AnnotationsRegistry.class, ClassLoader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = ClassGenerator.class.getDeclaredMethod("generateBytecode", String.class, GeneratedProxiesRegistry.Key.class, AnnotationsRegistry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = ClassGenerator.class.getDeclaredMethod("getIfaceType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = ClassGenerator.class.getDeclaredMethod("getProxyType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = ClassGenerator.class.getDeclaredMethod("getIfaceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = ClassGenerator.class.getDeclaredMethod("getSuperclassName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = ClassGenerator.class.getDeclaredMethod("getProxyName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }

    static class AnnotationsForIface {
        private final AnnotationsRegistry registry;
        private final Class iface;
        private final AnnotationsRegistry.Value value;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        AnnotationsForIface(AnnotationsRegistry registry, Class iface, AnnotationsRegistry.Value value) {
            this.registry = registry;
            this.iface = iface;
            this.value = value;
        }

        AnnotationsRegistry getRegistry() {
            return this.registry;
        }

        Class getIface() {
            return this.iface;
        }

        AnnotationsRegistry.Value getValue() {
            return this.value;
        }

        static {
            try {
                $$$methodRef$$$3 = AnnotationsForIface.class.getDeclaredConstructor(AnnotationsRegistry.class, Class.class, AnnotationsRegistry.Value.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = AnnotationsForIface.class.getDeclaredMethod("getValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = AnnotationsForIface.class.getDeclaredMethod("getIface", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = AnnotationsForIface.class.getDeclaredMethod("getRegistry", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

