/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.scanner.android;

import android.content.res.AssetManager;
import java.io.IOException;
import java.io.InputStreamReader;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.FileCopyUtils;
import org.flywaydb.core.internal.util.scanner.Resource;

public class AndroidResource
implements Resource {
    private final AssetManager assetManager;
    private final String path;
    private final String name;

    public AndroidResource(AssetManager assetManager, String path, String name) {
        this.assetManager = assetManager;
        this.path = path;
        this.name = name;
    }

    @Override
    public String getLocation() {
        return this.path + "/" + this.name;
    }

    @Override
    public String getLocationOnDisk() {
        return null;
    }

    @Override
    public String loadAsString(String encoding) {
        try {
            return FileCopyUtils.copyToString(new InputStreamReader(this.assetManager.open(this.getLocation()), encoding));
        }
        catch (IOException e2) {
            throw new FlywayException("Unable to load asset: " + this.getLocation(), e2);
        }
    }

    @Override
    public byte[] loadAsBytes() {
        try {
            return FileCopyUtils.copyToByteArray(this.assetManager.open(this.getLocation()));
        }
        catch (IOException e2) {
            throw new FlywayException("Unable to load asset: " + this.getLocation(), e2);
        }
    }

    @Override
    public String getFilename() {
        return this.name;
    }
}

