/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingResultSet;
import org.apache.commons.dbcp2.DelegatingStatement;

public class DelegatingPreparedStatement
extends DelegatingStatement
implements PreparedStatement {
    public DelegatingPreparedStatement(DelegatingConnection<?> connection, PreparedStatement statement) {
        super(connection, statement);
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().addBatch();
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().clearParameters();
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkOpen();
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().setLastUsed();
        }
        try {
            return this.getDelegatePreparedStatement().execute();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return false;
        }
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.checkOpen();
        try {
            return this.getDelegatePreparedStatement().executeLargeUpdate();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0L;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().setLastUsed();
        }
        try {
            return DelegatingResultSet.wrapResultSet(this, this.getDelegatePreparedStatement().executeQuery());
        }
        catch (SQLException e2) {
            this.handleException(e2);
            throw new AssertionError();
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkOpen();
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().setLastUsed();
        }
        try {
            return this.getDelegatePreparedStatement().executeUpdate();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }

    private PreparedStatement getDelegatePreparedStatement() {
        return (PreparedStatement)this.getDelegate();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        try {
            return this.getDelegatePreparedStatement().getMetaData();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            throw new AssertionError();
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkOpen();
        try {
            return this.getDelegatePreparedStatement().getParameterMetaData();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            throw new AssertionError();
        }
    }

    @Override
    public void setArray(int i2, Array x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setArray(i2, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setAsciiStream(parameterIndex, inputStream);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setAsciiStream(parameterIndex, x2, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setAsciiStream(parameterIndex, inputStream, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBigDecimal(parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBinaryStream(parameterIndex, inputStream);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBinaryStream(parameterIndex, x2, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBinaryStream(parameterIndex, inputStream, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBlob(int i2, Blob x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBlob(i2, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBlob(parameterIndex, inputStream);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBlob(parameterIndex, inputStream, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBoolean(parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setByte(parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBytes(parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setCharacterStream(parameterIndex, reader);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setClob(int i2, Clob x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setClob(i2, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setClob(parameterIndex, reader);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setClob(parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setDate(parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x2, Calendar cal) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setDate(parameterIndex, x2, cal);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setDouble(parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setFloat(parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setInt(parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setLong(parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNCharacterStream(parameterIndex, reader);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNCharacterStream(parameterIndex, value, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNClob(parameterIndex, value);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNClob(parameterIndex, reader);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNClob(parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNString(parameterIndex, value);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNull(parameterIndex, sqlType);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNull(paramIndex, sqlType, typeName);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setObject(parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setObject(parameterIndex, x2, targetSqlType);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x2, int targetSqlType, int scale) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setObject(parameterIndex, x2, targetSqlType, scale);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x2, SQLType targetSqlType) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setObject(parameterIndex, x2, targetSqlType);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setObject(parameterIndex, x2, targetSqlType, scaleOrLength);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setRef(int i2, Ref x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setRef(i2, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId value) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setRowId(parameterIndex, value);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setShort(parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML value) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setSQLXML(parameterIndex, value);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setString(int parameterIndex, String x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setString(parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setTime(parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x2, Calendar cal) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setTime(parameterIndex, x2, cal);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setTimestamp(parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setTimestamp(parameterIndex, x2, cal);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setUnicodeStream(parameterIndex, x2, length);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setURL(parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    @Override
    public synchronized String toString() {
        Statement statement = this.getDelegate();
        return statement == null ? "NULL" : statement.toString();
    }
}

