/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj;

import com.mysql.cj.AbstractQueryBindings;
import com.mysql.cj.Messages;
import com.mysql.cj.MysqlType;
import com.mysql.cj.ServerPreparedQueryBindValue;
import com.mysql.cj.Session;
import com.mysql.cj.conf.PropertyKey;
import com.mysql.cj.exceptions.ExceptionFactory;
import com.mysql.cj.exceptions.WrongArgumentException;
import com.mysql.cj.util.StringUtils;
import com.mysql.cj.util.TimeUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;

public class ServerPreparedQueryBindings
extends AbstractQueryBindings<ServerPreparedQueryBindValue> {
    private AtomicBoolean sendTypesToServer = new AtomicBoolean(false);
    private boolean longParameterSwitchDetected = false;

    public ServerPreparedQueryBindings(int parameterCount, Session sess) {
        super(parameterCount, sess);
    }

    @Override
    protected void initBindValues(int parameterCount) {
        this.bindValues = new ServerPreparedQueryBindValue[parameterCount];
        for (int i2 = 0; i2 < parameterCount; ++i2) {
            ((ServerPreparedQueryBindValue[])this.bindValues)[i2] = new ServerPreparedQueryBindValue(this.session.getServerSession().getDefaultTimeZone());
        }
    }

    @Override
    public ServerPreparedQueryBindings clone() {
        ServerPreparedQueryBindings newBindings = new ServerPreparedQueryBindings(((ServerPreparedQueryBindValue[])this.bindValues).length, this.session);
        ServerPreparedQueryBindValue[] bvs = new ServerPreparedQueryBindValue[((ServerPreparedQueryBindValue[])this.bindValues).length];
        for (int i2 = 0; i2 < ((ServerPreparedQueryBindValue[])this.bindValues).length; ++i2) {
            bvs[i2] = ((ServerPreparedQueryBindValue[])this.bindValues)[i2].clone();
        }
        newBindings.bindValues = bvs;
        newBindings.sendTypesToServer = this.sendTypesToServer;
        newBindings.longParameterSwitchDetected = this.longParameterSwitchDetected;
        newBindings.isLoadDataQuery = this.isLoadDataQuery;
        return newBindings;
    }

    public ServerPreparedQueryBindValue getBinding(int parameterIndex, boolean forLongData) {
        if (((ServerPreparedQueryBindValue[])this.bindValues)[parameterIndex] != null && ((ServerPreparedQueryBindValue[])this.bindValues)[parameterIndex].isStream && !forLongData) {
            this.longParameterSwitchDetected = true;
        }
        return ((ServerPreparedQueryBindValue[])this.bindValues)[parameterIndex];
    }

    @Override
    public void checkParameterSet(int columnIndex) {
        if (!((ServerPreparedQueryBindValue[])this.bindValues)[columnIndex].isSet()) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ServerPreparedStatement.13") + (columnIndex + 1) + Messages.getString("ServerPreparedStatement.14"));
        }
    }

    public AtomicBoolean getSendTypesToServer() {
        return this.sendTypesToServer;
    }

    public boolean isLongParameterSwitchDetected() {
        return this.longParameterSwitchDetected;
    }

    public void setLongParameterSwitchDetected(boolean longParameterSwitchDetected) {
        this.longParameterSwitchDetected = longParameterSwitchDetected;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x2) {
        this.setAsciiStream(parameterIndex, x2, -1);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x2, int length) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, true);
            this.sendTypesToServer.compareAndSet(false, binding.resetToType(252, this.numberOfExecutions));
            binding.value = x2;
            binding.isStream = true;
            binding.streamLength = (Boolean)this.useStreamLengthsInPrepStmts.getValue() != false ? (long)length : -1L;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x2, long length) {
        this.setAsciiStream(parameterIndex, x2, (int)length);
        ((ServerPreparedQueryBindValue[])this.bindValues)[parameterIndex].setMysqlType(MysqlType.TEXT);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x2) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, false);
            this.sendTypesToServer.compareAndSet(false, binding.resetToType(246, this.numberOfExecutions));
            binding.value = StringUtils.fixDecimalExponent(x2.toPlainString());
            binding.parameterType = MysqlType.DECIMAL;
        }
    }

    @Override
    public void setBigInteger(int parameterIndex, BigInteger x2) {
        this.setValue(parameterIndex, x2.toString(), MysqlType.BIGINT_UNSIGNED);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x2) {
        this.setBinaryStream(parameterIndex, x2, -1);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x2, int length) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, true);
            this.sendTypesToServer.compareAndSet(false, binding.resetToType(252, this.numberOfExecutions));
            binding.value = x2;
            binding.isStream = true;
            binding.streamLength = (Boolean)this.useStreamLengthsInPrepStmts.getValue() != false ? (long)length : -1L;
            binding.parameterType = MysqlType.BLOB;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x2, long length) {
        this.setBinaryStream(parameterIndex, x2, (int)length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) {
        this.setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) {
        this.setBinaryStream(parameterIndex, inputStream, (int)length);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x2) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            try {
                ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, true);
                this.sendTypesToServer.compareAndSet(false, binding.resetToType(252, this.numberOfExecutions));
                binding.value = x2;
                binding.isStream = true;
                binding.streamLength = (Boolean)this.useStreamLengthsInPrepStmts.getValue() != false ? x2.length() : -1L;
                binding.parameterType = MysqlType.BLOB;
            }
            catch (Throwable t2) {
                throw ExceptionFactory.createException(t2.getMessage(), t2);
            }
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x2) {
        ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, false);
        this.sendTypesToServer.compareAndSet(false, binding.resetToType(1, this.numberOfExecutions));
        binding.value = x2 ? 1L : 0L;
        binding.parameterType = MysqlType.BOOLEAN;
    }

    @Override
    public void setByte(int parameterIndex, byte x2) {
        ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, false);
        this.sendTypesToServer.compareAndSet(false, binding.resetToType(1, this.numberOfExecutions));
        binding.value = (long)x2;
        binding.parameterType = MysqlType.TINYINT;
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x2) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, false);
            this.sendTypesToServer.compareAndSet(false, binding.resetToType(253, this.numberOfExecutions));
            binding.value = x2;
            binding.parameterType = MysqlType.BINARY;
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x2, boolean checkForIntroducer, boolean escapeForMBChars) {
        this.setBytes(parameterIndex, x2);
    }

    @Override
    public void setBytesNoEscape(int parameterIndex, byte[] parameterAsBytes) {
        this.setBytes(parameterIndex, parameterAsBytes);
    }

    @Override
    public void setBytesNoEscapeNoQuotes(int parameterIndex, byte[] parameterAsBytes) {
        this.setBytes(parameterIndex, parameterAsBytes);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) {
        this.setCharacterStream(parameterIndex, reader, -1);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) {
        if (reader == null) {
            this.setNull(parameterIndex);
        } else {
            ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, true);
            this.sendTypesToServer.compareAndSet(false, binding.resetToType(252, this.numberOfExecutions));
            binding.value = reader;
            binding.isStream = true;
            binding.streamLength = (Boolean)this.useStreamLengthsInPrepStmts.getValue() != false ? (long)length : -1L;
            binding.parameterType = MysqlType.TEXT;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) {
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) {
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Clob x2) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            try {
                ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, true);
                this.sendTypesToServer.compareAndSet(false, binding.resetToType(252, this.numberOfExecutions));
                binding.value = x2.getCharacterStream();
                binding.isStream = true;
                binding.streamLength = (Boolean)this.useStreamLengthsInPrepStmts.getValue() != false ? x2.length() : -1L;
                binding.parameterType = MysqlType.TEXT;
            }
            catch (Throwable t2) {
                throw ExceptionFactory.createException(t2.getMessage(), t2);
            }
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x2) {
        this.setDate(parameterIndex, x2, null);
    }

    @Override
    public void setDate(int parameterIndex, Date x2, Calendar cal) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, false);
            this.sendTypesToServer.compareAndSet(false, binding.resetToType(10, this.numberOfExecutions));
            binding.value = x2;
            binding.calendar = cal == null ? null : (Calendar)cal.clone();
            binding.parameterType = MysqlType.DATE;
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x2) {
        if (!this.session.getPropertySet().getBooleanProperty(PropertyKey.allowNanAndInf).getValue().booleanValue() && (x2 == Double.POSITIVE_INFINITY || x2 == Double.NEGATIVE_INFINITY || Double.isNaN(x2))) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedStatement.64", new Object[]{x2}), this.session.getExceptionInterceptor());
        }
        ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, false);
        this.sendTypesToServer.compareAndSet(false, binding.resetToType(5, this.numberOfExecutions));
        binding.value = x2;
        binding.parameterType = MysqlType.DOUBLE;
    }

    @Override
    public void setFloat(int parameterIndex, float x2) {
        ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, false);
        this.sendTypesToServer.compareAndSet(false, binding.resetToType(4, this.numberOfExecutions));
        binding.value = Float.valueOf(x2);
        binding.parameterType = MysqlType.FLOAT;
    }

    @Override
    public void setInt(int parameterIndex, int x2) {
        ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, false);
        this.sendTypesToServer.compareAndSet(false, binding.resetToType(3, this.numberOfExecutions));
        binding.value = (long)x2;
        binding.parameterType = MysqlType.INT;
    }

    @Override
    public void setLong(int parameterIndex, long x2) {
        ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, false);
        this.sendTypesToServer.compareAndSet(false, binding.resetToType(8, this.numberOfExecutions));
        binding.value = x2;
        binding.parameterType = MysqlType.BIGINT;
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) {
        this.setNCharacterStream(parameterIndex, value, -1L);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader, long length) {
        if (!this.charEncoding.equalsIgnoreCase("UTF-8") && !this.charEncoding.equalsIgnoreCase("utf8")) {
            throw ExceptionFactory.createException(Messages.getString("ServerPreparedStatement.28"), this.session.getExceptionInterceptor());
        }
        if (reader == null) {
            this.setNull(parameterIndex);
        } else {
            ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, true);
            this.sendTypesToServer.compareAndSet(false, binding.resetToType(252, this.numberOfExecutions));
            binding.value = reader;
            binding.isStream = true;
            binding.streamLength = (Boolean)this.useStreamLengthsInPrepStmts.getValue() != false ? length : -1L;
            binding.parameterType = MysqlType.TEXT;
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) {
        this.setNCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) {
        if (!this.charEncoding.equalsIgnoreCase("UTF-8") && !this.charEncoding.equalsIgnoreCase("utf8")) {
            throw ExceptionFactory.createException(Messages.getString("ServerPreparedStatement.29"), this.session.getExceptionInterceptor());
        }
        this.setNCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) {
        try {
            this.setNClob(parameterIndex, value.getCharacterStream(), (Boolean)this.useStreamLengthsInPrepStmts.getValue() != false ? value.length() : -1L);
        }
        catch (Throwable t2) {
            throw ExceptionFactory.createException(t2.getMessage(), t2, this.session.getExceptionInterceptor());
        }
    }

    @Override
    public void setNString(int parameterIndex, String x2) {
        if (!this.charEncoding.equalsIgnoreCase("UTF-8") && !this.charEncoding.equalsIgnoreCase("utf8")) {
            throw ExceptionFactory.createException(Messages.getString("ServerPreparedStatement.30"), this.session.getExceptionInterceptor());
        }
        this.setString(parameterIndex, x2);
    }

    @Override
    public void setNull(int parameterIndex) {
        ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, false);
        this.sendTypesToServer.compareAndSet(false, binding.resetToType(6, this.numberOfExecutions));
        binding.setNull(true);
    }

    @Override
    public void setShort(int parameterIndex, short x2) {
        ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, false);
        this.sendTypesToServer.compareAndSet(false, binding.resetToType(2, this.numberOfExecutions));
        binding.value = (long)x2;
        binding.parameterType = MysqlType.SMALLINT;
    }

    @Override
    public void setString(int parameterIndex, String x2) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, false);
            this.sendTypesToServer.compareAndSet(false, binding.resetToType(253, this.numberOfExecutions));
            binding.value = x2;
            binding.charEncoding = this.charEncoding;
            binding.parameterType = MysqlType.VARCHAR;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x2, Calendar cal) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, false);
            this.sendTypesToServer.compareAndSet(false, binding.resetToType(11, this.numberOfExecutions));
            binding.value = x2;
            binding.calendar = cal == null ? null : (Calendar)cal.clone();
            binding.parameterType = MysqlType.TIME;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x2) {
        this.setTime(parameterIndex, x2, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x2) {
        int fractLen = -1;
        if (!((Boolean)this.sendFractionalSeconds.getValue()).booleanValue() || !this.session.getServerSession().getCapabilities().serverSupportsFracSecs()) {
            fractLen = 0;
        } else if (this.columnDefinition != null && parameterIndex <= this.columnDefinition.getFields().length && parameterIndex >= 0) {
            fractLen = this.columnDefinition.getFields()[parameterIndex].getDecimals();
        }
        this.setTimestamp(parameterIndex, x2, null, fractLen);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) {
        int fractLen = -1;
        if (!((Boolean)this.sendFractionalSeconds.getValue()).booleanValue() || !this.session.getServerSession().getCapabilities().serverSupportsFracSecs()) {
            fractLen = 0;
        } else if (this.columnDefinition != null && parameterIndex <= this.columnDefinition.getFields().length && parameterIndex >= 0 && this.columnDefinition.getFields()[parameterIndex].getDecimals() > 0) {
            fractLen = this.columnDefinition.getFields()[parameterIndex].getDecimals();
        }
        this.setTimestamp(parameterIndex, x2, cal, fractLen);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x2, Calendar targetCalendar, int fractionalLength) {
        if (x2 == null) {
            this.setNull(parameterIndex);
        } else {
            ServerPreparedQueryBindValue binding = this.getBinding(parameterIndex, false);
            this.sendTypesToServer.compareAndSet(false, binding.resetToType(12, this.numberOfExecutions));
            x2 = (Timestamp)x2.clone();
            if (!this.session.getServerSession().getCapabilities().serverSupportsFracSecs() || !((Boolean)this.sendFractionalSeconds.getValue()).booleanValue() && fractionalLength == 0) {
                x2 = TimeUtil.truncateFractionalSeconds(x2);
            }
            if (fractionalLength < 0) {
                fractionalLength = 6;
            }
            x2 = TimeUtil.adjustTimestampNanosPrecision(x2, fractionalLength, !this.session.getServerSession().isServerTruncatesFracSecs());
            binding.value = x2;
            binding.calendar = targetCalendar == null ? null : (Calendar)targetCalendar.clone();
            binding.parameterType = MysqlType.TIMESTAMP;
        }
    }
}

